package com.xebialabs.xlrelease.stress.domain

import spray.json._
import spray.json.DefaultJsonProtocol._

case class Configuration(ciType: String, content: JsObject, id: Option[Configuration.ID] = None) {
  def body: JsObject = JsObject(content.fields ++ Map(
    "id" -> JsNull,
    "type" -> ciType.toJson
  ))
}


object Configuration {
  type ID = String

  def postWebhook(endpointPath: String, title: String, authentication: JsObject = Webhooks.NoAuthentication): Configuration =
    Configuration("events.PostWebhookEndpoint", JsObject(
      "title" -> "test webhook for performance".toJson,
      "path" -> endpointPath.toJson,
      "authentication" -> authentication
    ))

  object Webhooks {
    def NoAuthentication: JsObject = JsObject(
      "id" -> JsNull,
      "type" -> "events.NoAuthentication".toJson
    )
    def GithubAuthentication(secret: String): JsObject = JsObject(
      "id" -> JsNull,
      "type" -> "events.GithubAuthentication".toJson,
      "githubSecret" -> secret.toJson
    )
  }

}