package com.xebialabs.xlrelease.stress.config

import java.nio.file.Path

import akka.http.scaladsl.model.Uri
import com.xebialabs.xlrelease.stress.config.GrafanaConfig.{DashboardConfig, DashboardsConfig, PanelConfig, ServerConfig}

case class GrafanaConfig(server: ServerConfig,
                         dashboards: DashboardsConfig,
                         panels: Map[DashboardConfig, Set[PanelConfig]]) {

}

object GrafanaConfig {
  case class ServerConfig(url: String, token: String, enabled: Boolean, downloadDir: Path) {
    lazy val server = Uri(url)

    lazy val rootPath: Uri.Path = server.path

    def api(path: Uri.Path => Uri.Path): Uri = server.withPath(path(rootPath))
  }


  case class PanelConfig(id: Int, name: String)

  case class DashboardConfig(id: String, name: String,
                             parameters: Map[String, String])

  case class DashboardsConfig(orgId: Int,
                              width: Int,
                              height: Int,
                              timezone: String)

}