package com.xebialabs.xlrelease.stress.api.xlr

import com.xebialabs.xlrelease.stress.api
import com.xebialabs.xlrelease.stress.api.CoreAPI
import com.xebialabs.xlrelease.stress.config.XlrConfig

import scala.concurrent.ExecutionContext

class XlrAPI(core: CoreAPI, xlrConfig: XlrConfig)(implicit val ec: ExecutionContext) {
  import core._

  implicit lazy val configurations: api.xlr.Configurations = new api.xlr.Configurations(xlrConfig.server)
  implicit lazy val folders: api.xlr.Folders = new api.xlr.Folders(xlrConfig.server)
  implicit lazy val phases: api.xlr.Phases = new api.xlr.Phases(xlrConfig.server)
  implicit lazy val releases: api.xlr.Releases = new api.xlr.Releases(xlrConfig.server)
  implicit lazy val tasks: api.xlr.Tasks = new api.xlr.Tasks(xlrConfig.server)
  implicit lazy val templates: api.xlr.Templates = new api.xlr.Templates(xlrConfig.server)
  implicit lazy val patterns: api.xlr.Patterns = new api.xlr.Patterns(xlrConfig.server)
  implicit lazy val deliveries: api.xlr.Deliveries = new api.xlr.Deliveries(xlrConfig.server)
  implicit lazy val users: api.xlr.Users = new api.xlr.Users(xlrConfig.server, xlrConfig.username, xlrConfig.password)
}
