package com.xebialabs.xlrelease.stress.api.xlr

import cats.effect.IO
import cats.implicits._
import com.github.nscala_time.time.Imports.DateTime
import com.xebialabs.xlrelease.stress.{Scenario, api}
import com.xebialabs.xlrelease.stress.config.XlrServer
import com.xebialabs.xlrelease.stress.domain._
import com.xebialabs.xlrelease.stress.protocol.{DateFormat}
import com.xebialabs.xlrelease.stress.utils.HttpHelpers.JsonToHttpEntity
import com.xebialabs.xlrelease.stress.utils.IOHelpers.EitherToIO
import com.xebialabs.xlrelease.stress.utils.JsUtils
import spray.json._

import scala.language.postfixOps

class Deliveries(server: XlrServer)
                (implicit
                 http: api.http.Client with api.http.Session,
                 control: api.control.Control with api.control.Flow,
                 log: api.log.Logging with api.log.Session,
                 json: api.json.JsonParser) extends DefaultJsonProtocol with DateFormat {

  def createFromPattern(title: String, patternId: Pattern.ID, folderId: Folder.ID)
                       (implicit session: User.Session, scenario: Scenario): IO[Delivery.ID] = {
    val payload = JsObject(
      "id" -> JsNull,
      "type" -> "delivery.Delivery".toJson,
      "title" -> title.toJson,
      "description" -> "test description".toJson,
      "folderId" -> ("Applications/" + folderId).toJson,
      "plannedDuration" -> JsNumber.zero,
      "startDate" -> DateTime.now.toString.toJson,
      "endDate" -> DateTime.nextMonth().toString.toJson
    )
    for {
      _ <- log.session.debug(s"xlr.deliveries.createFromPattern(${patternId.show})")
      resp <- http.session.post(server.api(_ ?/ "delivery-patterns" / "Applications" ++ patternId.path / "create"), payload.toHttpEntity)
      content <- json.parse(resp)
      deliveryId <- JsUtils.readIdString(content).io
    } yield Delivery.ID(deliveryId)
  }

  def addTrackedItem(title: String, deliveryId: Delivery.ID)
                    (implicit session: User.Session, scenario: Scenario): IO[TrackedItem.ID] = {
    val payload = JsObject(
      "id" -> JsNull,
      "title" -> title.toJson,
      "type" -> "delivery.TrackedItem".toJson
    )
    for {
      _ <- log.session.debug(s"xlr.deliveries.addTrackedItem($title)")
      resp <- http.session.post(server.api(_ ?/ "delivery-patterns" ++ deliveryId.path + "/tracked-items"), payload.toHttpEntity)
      content <- json.parse(resp)
      trackedItemId <- JsUtils.readIdString(content).io
    } yield TrackedItem.ID(trackedItemId)
  }
}
