package com.xebialabs.xlrelease.stress.api.metric

import cats.effect.IO
import com.xebialabs.xlrelease.stress.Scenario
import com.xebialabs.xlrelease.stress.domain.Task
import com.xebialabs.xlrelease.stress.handlers.Meter

import scala.concurrent.duration.FiniteDuration

trait MetricFunction {
  def add(duration: FiniteDuration): IO[Unit]

  def measure[A](p: IO[(FiniteDuration, A)]): IO[A] =
    for {
      result <- p
      (duration, value) = result
      _ <- add(duration)
    } yield value
}

trait Metric {
  def named(name: String)
           (implicit scenario: Scenario): MetricFunction

  def getState: IO[Map[String, Meter]]

  def clear(): IO[Unit]
}

trait MetricFlusher {
  def flush(taskId: Task.ID)
           (implicit scenario: Scenario): IO[Unit]
}
