package com.xebialabs.xlrelease.stress.api.log

import cats.effect.IO
import com.xebialabs.xlrelease.stress.Scenario
import com.xebialabs.xlrelease.stress.domain.User

trait Session { log: Logging =>

  object session {
    def error(msg: => String)(implicit scenario: Scenario, session: User.Session): IO[Unit] = log.error(sessionLog(msg))
    def warn(msg: => String)(implicit scenario: Scenario, session: User.Session): IO[Unit] = log.warn(sessionLog(msg))
    def info(msg: => String)(implicit scenario: Scenario, session: User.Session): IO[Unit] = log.info(sessionLog(msg))
    def debug(msg: => String)(implicit scenario: Scenario, session: User.Session): IO[Unit] = log.debug(sessionLog(msg))
  }

  protected def sessionLog(msg: => String)(implicit session: User.Session) = s"${session.user.username}: $msg"

}
