package com.xebialabs.xlrelease.stress.api.log

import cats.effect.IO
import com.xebialabs.xlrelease.stress.Scenario

trait Logging { raw: Raw =>

  def error(msg: => String)(implicit scenario: Scenario): IO[Unit] = raw.logError(scenarioLog(msg))
  def warn(msg: => String)(implicit scenario: Scenario): IO[Unit] = raw.logWarn(scenarioLog(msg))
  def info(msg: => String)(implicit scenario: Scenario): IO[Unit] = raw.logInfo(scenarioLog(msg))
  def debug(msg: => String)(implicit scenario: Scenario): IO[Unit] = raw.logDebug(scenarioLog(msg))

  private def scenarioLog(msg: => String)(implicit scenario: Scenario) = s"${scenario.name}: $msg"
}
