package com.xebialabs.xlrelease.stress.api.http

import akka.http.scaladsl.model.headers.RawHeader
import akka.http.scaladsl.model.{HttpHeader, HttpResponse, RequestEntity, Uri}
import cats.effect.IO
import com.xebialabs.xlrelease.stress.config.defaults.http.client.{headers => defaultHeaders}
import com.xebialabs.xlrelease.stress.domain.User

trait Session {
  client: Client =>

  object session {
    def get(uri: Uri, headers: List[HttpHeader] = defaultHeaders)
           (implicit session: User.Session): IO[HttpResponse] =
      client.get(uri, sessionHeaders(headers))

    def post(uri: Uri, entity: RequestEntity, headers: List[HttpHeader] = defaultHeaders)
            (implicit session: User.Session): IO[HttpResponse] =
      client.post(uri, entity, sessionHeaders(headers))

    def put(uri: Uri, entity: RequestEntity, headers: List[HttpHeader] = defaultHeaders)
           (implicit session: User.Session): IO[HttpResponse] =
      client.put(uri, entity, sessionHeaders(headers))

    def delete(uri: Uri, headers: List[HttpHeader] = defaultHeaders)
              (implicit session: User.Session): IO[HttpResponse] =
      client.delete(uri, sessionHeaders(headers))
  }

  protected def sessionHeaders(headers: List[HttpHeader])
                              (implicit session: User.Session): List[HttpHeader] =
    headers ++ (session.cookies +: xsrfHeader.toList)

  protected def xsrfHeader(implicit session: User.Session): Option[HttpHeader] = {
    session.cookies.cookies.find(_.name == "XSRF-TOKEN").map { xsrfToken =>
      RawHeader("X-XSRF-TOKEN", xsrfToken.value)
    }
  }

}
