package com.xebialabs.xlrelease.stress.api.http

import akka.http.scaladsl.model.{HttpHeader, HttpResponse, RequestEntity, Uri}
import cats.effect.IO
import com.xebialabs.xlrelease.stress.config.defaults.http.client.{headers => defaultHeaders}

trait Client {
  def get(uri: Uri, headers: List[HttpHeader] = defaultHeaders): IO[HttpResponse]
  def post(uri: Uri, entity: RequestEntity, headers: List[HttpHeader] = defaultHeaders): IO[HttpResponse]
  def put(uri: Uri, entity: RequestEntity, headers: List[HttpHeader] = defaultHeaders): IO[HttpResponse]
  def delete(uri: Uri, headers: List[HttpHeader] = defaultHeaders): IO[HttpResponse]

  def discard(resp: HttpResponse): IO[Unit]
}
