package com.xebialabs.xlrelease.stress.api.control

import cats.effect.IO
import cats.implicits._
import org.joda.time.DateTime

import scala.concurrent.duration.FiniteDuration

trait Flow {
  def sleep(duration: FiniteDuration): IO[Unit]

  def fork[A, B](left: IO[A], right: IO[B]): IO[(A, B)]

  def backgroundOf[A, B](foreground: IO[A])(background: IO[B]): IO[(A, List[B])]

  def repeat[A](n: Int)(p: IO[A]): IO[List[A]]

  def parallel[A](n: Int)(p: Int => IO[A]): IO[List[A]]

  def sequenced[A](n: Int, start: Int = 0)(p: Int => IO[A]): IO[List[A]]

  def concurrently[A](n: Int)(queue: Iterable[IO[A]]): IO[List[List[A]]]

  def now(): IO[DateTime]

  def time[A](program: IO[A]): IO[(FiniteDuration, A)]

  def shutdown(): IO[Unit]

  def until[A](cond: A => Boolean, interval: FiniteDuration, retries: Option[Int])
              (get: IO[A]): IO[A]
}
