package com.xebialabs.xlrelease.stress.api.control

import cats.effect.IO

trait Control {

  def nop: IO[Unit]

  def ok[A](a: A): IO[A]

  def fail[A](msg: => String, cause: => Throwable): IO[A]

  def fail[A](msg: => String): IO[A] = fail(msg, null)

  def error[A](err: => Throwable): IO[A]

}
