package com.xebialabs.xlrelease.stress.api

import cats.effect.{ContextShift, IO}
import cats.implicits._
import com.xebialabs.xlrelease.stress.api
import com.xebialabs.xlrelease.stress.handlers._
import com.xebialabs.xlrelease.stress.utils.AkkaHttpClient
import com.xebialabs.xlrelease.stress.utils.IOHelpers.FutureToIO

import scala.concurrent.ExecutionContext

class CoreAPI()(implicit val ec: ExecutionContext) {
  val akkaHttpClient = new AkkaHttpClient

  implicit lazy val metric: api.metric.Metric = new MetricHandler()
  implicit lazy val control: api.control.Control with api.control.Flow = new ControlHandler()
  implicit lazy val log: api.log.Raw with api.log.Logging with api.log.Session = new LoggingHandler
  implicit lazy val cs: ContextShift[IO] = IO.contextShift(ec)
  implicit lazy val http: api.http.Client with api.http.Session = new HttpHandler(akkaHttpClient)
  implicit lazy val json: api.json.JsonParser = new JsonHandler(akkaHttpClient)

  def shutdown(): IO[Unit] = control.shutdown() >> akkaHttpClient.shutdown().io
}
