package com.xebialabs.xlrelease.stress

import cats.effect.{ContextShift, IO}
import com.xebialabs.xlrelease.stress.api.CoreAPI
import com.xebialabs.xlrelease.stress.api.metric.GrafanaClient
import com.xebialabs.xlrelease.stress.api.xlr.XlrAPI
import com.xebialabs.xlrelease.stress.config.{ReportingXlrConfig, XlrConfig}
import com.xebialabs.xlrelease.stress.handlers.MetricsFlusherHandler

import scala.concurrent.ExecutionContext

abstract class BaseAPI(val xlrConfig: XlrConfig)
                      (implicit ec: ExecutionContext) extends CoreAPI() {
  self =>
  implicit lazy val xlr: XlrAPI = new XlrAPI(self, xlrConfig)
}

class API(xlrConfig: XlrConfig)(implicit ec: ExecutionContext) extends BaseAPI(xlrConfig)(ec)

class ReportingAPI(core: CoreAPI, val reportingXlrConfig: ReportingXlrConfig)
                  (implicit ec: ExecutionContext) {
  implicit lazy val xlr: XlrAPI = new XlrAPI(core, reportingXlrConfig.xlrConfig)

  import core.akkaHttpClient.materializer

  implicit lazy val metric: api.metric.Metric = core.metric
  implicit lazy val control: api.control.Control with api.control.Flow = core.control
  implicit lazy val log: api.log.Raw with api.log.Logging with api.log.Session = core.log
  implicit lazy val http: api.http.Client with api.http.Session = core.http
  implicit lazy val json: api.json.JsonParser = core.json
  implicit lazy val cs: ContextShift[IO] = IO.contextShift(ec)

  implicit lazy val grafana: api.metric.GrafanaClient = new GrafanaClient(reportingXlrConfig.grafanaConfig.server)
  implicit lazy val metricFlusher: api.metric.MetricFlusher = new MetricsFlusherHandler(reportingXlrConfig)
}