/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.stress.utils;

import cats.Applicative;
import cats.FlatMap;
import cats.implicits$;
import cats.syntax.EitherIdOps$;
import cats.syntax.EitherOps$;
import cats.syntax.FlatMapOps$;
import com.xebialabs.xlrelease.stress.domain.Comment;
import com.xebialabs.xlrelease.stress.domain.Dependency;
import com.xebialabs.xlrelease.stress.domain.Folder;
import com.xebialabs.xlrelease.stress.domain.Phase;
import com.xebialabs.xlrelease.stress.domain.Release;
import com.xebialabs.xlrelease.stress.domain.ReleaseStatus;
import com.xebialabs.xlrelease.stress.domain.ReleaseStatus$;
import com.xebialabs.xlrelease.stress.domain.Task;
import com.xebialabs.xlrelease.stress.domain.TaskStatus;
import com.xebialabs.xlrelease.stress.domain.TaskStatus$;
import com.xebialabs.xlrelease.stress.domain.Team;
import com.xebialabs.xlrelease.stress.domain.Team$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import spray.json.DeserializationException;
import spray.json.DeserializationException$;
import spray.json.JsArray;
import spray.json.JsBoolean;
import spray.json.JsNull$;
import spray.json.JsNumber;
import spray.json.JsObject;
import spray.json.JsString;
import spray.json.JsValue;
import spray.json.JsonReader;
import spray.json.SerializationException;

public final class JsUtils$ {
    public static JsUtils$ MODULE$;

    static {
        new JsUtils$();
    }

    public Function1<JsValue, Either<DeserializationException, JsObject>> jsObject() {
        return (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Either either;
            JsValue jsValue = x0$1;
            if (jsValue instanceof JsObject) {
                JsObject jsObject = (JsObject)jsValue;
                either = EitherIdOps$.MODULE$.asRight$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)jsObject));
            } else {
                either = MODULE$.wrongType("jsObject", "JsObject", jsValue);
            }
            return either;
        };
    }

    public Function1<JsValue, Either<DeserializationException, JsArray>> jsArray() {
        return (Function1 & Serializable & scala.Serializable)x0$2 -> {
            Either either;
            JsValue jsValue = x0$2;
            if (jsValue instanceof JsArray) {
                JsArray jsArray = (JsArray)jsValue;
                either = EitherIdOps$.MODULE$.asRight$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)jsArray));
            } else {
                either = MODULE$.wrongType("jsArray", "JsArray", jsValue);
            }
            return either;
        };
    }

    public Function1<JsValue, Either<DeserializationException, JsString>> jsString() {
        return (Function1 & Serializable & scala.Serializable)x0$3 -> {
            Either either;
            JsValue jsValue = x0$3;
            if (jsValue instanceof JsString) {
                JsString jsString = (JsString)jsValue;
                either = EitherIdOps$.MODULE$.asRight$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)jsString));
            } else {
                either = MODULE$.wrongType("jsString", "JsString", jsValue);
            }
            return either;
        };
    }

    public Function1<JsValue, Either<DeserializationException, JsBoolean>> jsBoolean() {
        return (Function1 & Serializable & scala.Serializable)x0$4 -> {
            Either either;
            JsValue jsValue = x0$4;
            if (jsValue instanceof JsBoolean) {
                JsBoolean jsBoolean = (JsBoolean)jsValue;
                either = EitherIdOps$.MODULE$.asRight$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)jsBoolean));
            } else {
                either = MODULE$.wrongType("jsBoolean", "JsBoolean", jsValue);
            }
            return either;
        };
    }

    public Function1<JsValue, Either<DeserializationException, Seq<JsValue>>> getElements() {
        return (Function1 & Serializable & scala.Serializable)json -> ((Either)MODULE$.jsArray().apply(json)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.elements());
    }

    public Function1<JsValue, Either<DeserializationException, String>> getString() {
        return (Function1 & Serializable & scala.Serializable)json -> ((Either)MODULE$.jsString().apply(json)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.value());
    }

    public Function1<JsValue, Either<DeserializationException, Map<String, JsValue>>> getFields() {
        return (Function1 & Serializable & scala.Serializable)json -> ((Either)MODULE$.jsObject().apply(json)).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.fields());
    }

    public Function1<JsValue, Either<DeserializationException, JsValue>> getField(String key) {
        return (Function1 & Serializable & scala.Serializable)json -> ((Either)MODULE$.jsObject().apply(json)).flatMap((Function1 & Serializable & scala.Serializable)obj -> ((Either)obj.fields().get((Object)key).map((Function1 & Serializable & scala.Serializable)x$4 -> EitherIdOps$.MODULE$.asRight$extension(implicits$.MODULE$.catsSyntaxEitherId(x$4))).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.notFound("getField", key, (JsValue)obj))).map((Function1 & Serializable & scala.Serializable)res -> res));
    }

    public Function1<JsValue, Either<DeserializationException, JsObject>> getObjectField(String key) {
        return (Function1 & Serializable & scala.Serializable)json -> ((Either)MODULE$.getField(key).apply(json)).flatMap((Function1 & Serializable & scala.Serializable)field -> ((Either)MODULE$.jsObject().apply(field)).map((Function1 & Serializable & scala.Serializable)obj -> obj));
    }

    public Function1<JsValue, Either<DeserializationException, JsString>> getStringField(String key) {
        return (Function1 & Serializable & scala.Serializable)json -> ((Either)MODULE$.getField(key).apply(json)).flatMap((Function1 & Serializable & scala.Serializable)field -> ((Either)MODULE$.jsString().apply(field)).map((Function1 & Serializable & scala.Serializable)str -> str));
    }

    public Function1<JsValue, Either<DeserializationException, JsArray>> getArrayField(String key) {
        return (Function1 & Serializable & scala.Serializable)json -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.getField(key).apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), MODULE$.jsArray(), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<JsValue, Either<DeserializationException, JsBoolean>> getBooleanField(String key) {
        return (Function1 & Serializable & scala.Serializable)json -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.getField(key).apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), MODULE$.jsBoolean(), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<JsValue, Either<DeserializationException, Seq<JsValue>>> getElements(String key) {
        return (Function1 & Serializable & scala.Serializable)json -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.getField(key).apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), MODULE$.getElements(), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<JsValue, Either<DeserializationException, JsValue>> getFirst() {
        return (Function1 & Serializable & scala.Serializable)json -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.getFirstOption().apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), (Function1 & Serializable & scala.Serializable)x0$5 -> {
            Either either;
            Option option = x0$5;
            if (None$.MODULE$.equals(option)) {
                either = MODULE$.err("getFirst: empty array.", (JsValue)json, MODULE$.err$default$3());
            } else if (option instanceof Some) {
                Some some = (Some)option;
                JsValue first = (JsValue)some.value();
                either = EitherIdOps$.MODULE$.asRight$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)first));
            } else {
                throw new MatchError((Object)option);
            }
            return either;
        }, (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<JsValue, Either<DeserializationException, Option<JsValue>>> getFirstOption() {
        return (Function1 & Serializable & scala.Serializable)json -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.jsArray().apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), (Function1 & Serializable & scala.Serializable)array -> EitherIdOps$.MODULE$.asRight$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)array.elements().headOption())), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<JsValue, Either<DeserializationException, String>> readIdString() {
        return (Function1 & Serializable & scala.Serializable)json -> ((Either)MODULE$.getStringField("id").apply(json)).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.value().replaceFirst("Applications/", ""));
    }

    public Function1<JsValue, Either<DeserializationException, String>> readFirstId() {
        return (Function1 & Serializable & scala.Serializable)json -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.getFirst().apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), MODULE$.readIdString(), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<JsValue, Either<DeserializationException, Folder.ID>> readFolderId(String sep) {
        return (Function1 & Serializable & scala.Serializable)json -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.readIdString().apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), MODULE$.parseFolderId(sep), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<JsValue, Either<DeserializationException, Task.ID>> readTaskId(String sep) {
        return (Function1 & Serializable & scala.Serializable)json -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.readIdString().apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), MODULE$.parseTaskId(sep), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<JsValue, Either<DeserializationException, List<Task.ID>>> readTaskIds(String sep) {
        return (Function1 & Serializable & scala.Serializable)json -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.getElements().apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), MODULE$.readTaskIdsInner(sep), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<Seq<JsValue>, Either<DeserializationException, List<Task.ID>>> readTaskIdsInner(String sep) {
        return (Function1 & Serializable & scala.Serializable)elements -> (Either)implicits$.MODULE$.toTraverseOps(elements.toList().map((Function1 & Serializable & scala.Serializable)e -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.readIdString().apply(e), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), MODULE$.parseTaskId(sep), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), List$.MODULE$.canBuildFrom()), implicits$.MODULE$.catsStdInstancesForList()).sequence(Predef$.MODULE$.$conforms(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<JsValue, Either<DeserializationException, Dependency.ID>> readDependencyId(String sep) {
        return (Function1 & Serializable & scala.Serializable)json -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.readIdString().apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), MODULE$.parseDependencyId(sep), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<JsValue, Either<DeserializationException, JsValue>> getStatus() {
        return this.getField("status");
    }

    public Function1<JsValue, Either<DeserializationException, TaskStatus>> readTaskStatus() {
        return (Function1 & Serializable & scala.Serializable)json -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.getStatus().apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), MODULE$.toTaskStatus(), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<JsValue, Either<DeserializationException, Option<TaskStatus>>> readFirstTaskStatus() {
        return (Function1 & Serializable & scala.Serializable)json -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.getFirstOption().apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), (Function1 & Serializable & scala.Serializable)x0$6 -> {
            Either either;
            Option option = x0$6;
            if (None$.MODULE$.equals(option)) {
                either = EitherIdOps$.MODULE$.asRight$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)Option$.MODULE$.empty()));
            } else if (option instanceof Some) {
                Either either2;
                Some some = (Some)option;
                JsValue first = (JsValue)some.value();
                Either either3 = (Either)MODULE$.readTaskStatus().apply((Object)first);
                if (either3 instanceof Left) {
                    either2 = EitherIdOps$.MODULE$.asRight$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)Option$.MODULE$.empty()));
                } else if (either3 instanceof Right) {
                    Right right = (Right)either3;
                    TaskStatus status = (TaskStatus)right.value();
                    either2 = EitherIdOps$.MODULE$.asRight$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)new Some((Object)status)));
                } else {
                    throw new MatchError((Object)either3);
                }
                either = either2;
            } else {
                throw new MatchError((Object)option);
            }
            return either;
        }, (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<JsValue, Object> matchesTaskStatus(TaskStatus expectedStatus) {
        return (Function1 & Serializable & scala.Serializable)json -> BoxesRunTime.boxToBoolean((boolean)JsUtils$.$anonfun$matchesTaskStatus$1(expectedStatus, json));
    }

    public Function1<JsValue, Either<DeserializationException, ReleaseStatus>> readReleaseStatus() {
        return (Function1 & Serializable & scala.Serializable)json -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.getStatus().apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), MODULE$.toReleaseStatus(), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<JsValue, Either<DeserializationException, Tuple2<Release.ID, ReleaseStatus>>> readReleaseIdAndStatus() {
        return (Function1 & Serializable & scala.Serializable)json -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.jsObject().apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), (Function1 & Serializable & scala.Serializable)obj -> ((Either)MODULE$.readIdString().apply(obj)).flatMap((Function1 & Serializable & scala.Serializable)id -> ((Either)MODULE$.readReleaseStatus().apply(obj)).map((Function1 & Serializable & scala.Serializable)status -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Release.ID((String)id)), status))), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<JsValue, Either<DeserializationException, Phase.ID>> readFirstPhaseId(String sep) {
        return (Function1 & Serializable & scala.Serializable)json -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.getField("phases").apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), MODULE$.readFirstId(), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), MODULE$.parsePhaseId(sep), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<JsValue, Either<DeserializationException, Tuple2<String, String>>> getTeamIdEntry() {
        return (Function1 & Serializable & scala.Serializable)json -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.jsObject().apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), (Function1 & Serializable & scala.Serializable)obj -> ((Either)MODULE$.getStringField("teamName").apply(obj)).flatMap((Function1 & Serializable & scala.Serializable)teamName -> ((Either)MODULE$.getStringField("id").apply(obj)).map((Function1 & Serializable & scala.Serializable)id -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)teamName.value()), (Object)id.value()))), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<JsValue, Either<DeserializationException, Map<String, String>>> readTeamIds() {
        return (Function1 & Serializable & scala.Serializable)json -> ((Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.getElements().apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), MODULE$.readTeamIdsInner(), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toMap(Predef$.MODULE$.$conforms()));
    }

    public Function1<Seq<JsValue>, Either<DeserializationException, List<Tuple2<String, String>>>> readTeamIdsInner() {
        return (Function1 & Serializable & scala.Serializable)elements -> (Either)implicits$.MODULE$.toTraverseOps(elements.toList().map(MODULE$.getTeamIdEntry(), List$.MODULE$.canBuildFrom()), implicits$.MODULE$.catsStdInstancesForList()).sequence(Predef$.MODULE$.$conforms(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<JsValue, Either<DeserializationException, Seq<Team>>> readTeams() {
        return (Function1 & Serializable & scala.Serializable)json -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.getElements().apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), MODULE$.readTeamsInner(), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<Seq<JsValue>, Either<DeserializationException, List<Team>>> readTeamsInner() {
        return (Function1 & Serializable & scala.Serializable)elements -> (Either)implicits$.MODULE$.toTraverseOps(elements.toList().map(MODULE$.readTeam((JsonReader<Team>)Team$.MODULE$.teamReader()), List$.MODULE$.canBuildFrom()), implicits$.MODULE$.catsStdInstancesForList()).sequence(Predef$.MODULE$.$conforms(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<JsValue, Either<DeserializationException, Team>> readTeam(JsonReader<Team> r) {
        return (Function1 & Serializable & scala.Serializable)json -> MODULE$.convert((JsValue)json, (JsonReader)r);
    }

    public Function1<JsValue, Either<DeserializationException, String>> readUsername() {
        return (Function1 & Serializable & scala.Serializable)json -> ((Either)MODULE$.getStringField("username").apply(json)).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.value());
    }

    public Function1<JsValue, Either<DeserializationException, Comment>> readComment() {
        return (Function1 & Serializable & scala.Serializable)json -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.jsObject().apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), (Function1 & Serializable & scala.Serializable)obj -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.getStringField("type").apply(obj), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), (Function1 & Serializable & scala.Serializable)x0$7 -> {
            String string;
            JsString jsString = x0$7;
            Either either = jsString != null && "xlrelease.Comment".equals(string = jsString.value()) ? ((Either)MODULE$.getStringField("id").apply(obj)).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.value()).flatMap((Function1 & Serializable & scala.Serializable)id -> EitherOps$.MODULE$.orElse$extension(implicits$.MODULE$.catsSyntaxEither(((Either)MODULE$.getStringField("author").apply(obj)).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.value())), (Function0 & Serializable & scala.Serializable)() -> EitherIdOps$.MODULE$.asRight$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)""))).flatMap((Function1 & Serializable & scala.Serializable)author -> ((Either)MODULE$.getStringField("date").apply(obj)).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.value()).flatMap((Function1 & Serializable & scala.Serializable)date -> ((Either)MODULE$.getStringField("text").apply(obj)).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.value()).map((Function1 & Serializable & scala.Serializable)text -> new Comment((String)id, (String)author, (String)date, (String)text))))) : MODULE$.wrongType("Not a comment", "type: xlrelease.Comment", (JsValue)obj);
            return either;
        }, (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<JsValue, Either<DeserializationException, Seq<Comment>>> readComments() {
        return (Function1 & Serializable & scala.Serializable)json -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.getField("comments").apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), MODULE$.getElements(), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), (Function1 & Serializable & scala.Serializable)x$12 -> (Either)implicits$.MODULE$.toTraverseOps(x$12.toList().map(MODULE$.readComment(), List$.MODULE$.canBuildFrom()), implicits$.MODULE$.catsStdInstancesForList()).sequence(Predef$.MODULE$.$conforms(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither()), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<JsValue, Either<DeserializationException, Map<Task, TaskStatus>>> readTasksAndStatuses() {
        return (Function1 & Serializable & scala.Serializable)json -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.getField("phases").apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), MODULE$.getElements(), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), (Function1 & Serializable & scala.Serializable)x$13 -> ((Either)implicits$.MODULE$.toTraverseOps(x$13.toList().map(MODULE$.readTasksAndStatusesFromTaskContainer(), List$.MODULE$.canBuildFrom()), implicits$.MODULE$.catsStdInstancesForList()).flatSequence(Predef$.MODULE$.$conforms(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither(), (FlatMap)implicits$.MODULE$.catsStdInstancesForList())).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.toMap(Predef$.MODULE$.$conforms())), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    private Function1<JsValue, Either<DeserializationException, List<Tuple2<Task, TaskStatus>>>> readTasksAndStatusesFromTaskContainer() {
        return (Function1 & Serializable & scala.Serializable)json -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.jsObject().apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), (Function1 & Serializable & scala.Serializable)obj -> !obj.fields().contains((Object)"tasks") ? package$.MODULE$.Right().apply((Object)List$.MODULE$.empty()) : (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.getElements("tasks").apply(obj), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), (Function1 & Serializable & scala.Serializable)elements -> ((Either)implicits$.MODULE$.toTraverseOps(elements.toList().map((Function1 & Serializable & scala.Serializable)taskObj -> ((Either)MODULE$.readTaskAndStatus().apply(taskObj)).flatMap((Function1 & Serializable & scala.Serializable)thisTask -> ((Either)MODULE$.readTasksAndStatusesFromTaskContainer().apply(taskObj)).map((Function1 & Serializable & scala.Serializable)subTasks -> {
            Tuple2 tuple2 = thisTask;
            return subTasks.$colon$colon((Object)tuple2);
        })), List$.MODULE$.canBuildFrom()), implicits$.MODULE$.catsStdInstancesForList()).sequence(Predef$.MODULE$.$conforms(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable & scala.Serializable)x$16 -> (List)x$16.flatten((Function1)Predef$.MODULE$.$conforms())), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    private Function1<JsValue, Either<DeserializationException, Tuple2<Task, TaskStatus>>> readTaskAndStatus() {
        return (Function1 & Serializable & scala.Serializable)json -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.jsObject().apply(json), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), (Function1 & Serializable & scala.Serializable)obj -> ((Either)MODULE$.readTaskId("/").apply(obj)).flatMap((Function1 & Serializable & scala.Serializable)id -> ((Either)MODULE$.getStringField("type").apply(obj)).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.value()).flatMap((Function1 & Serializable & scala.Serializable)taskType -> ((Either)MODULE$.getStringField("title").apply(obj)).map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.value()).flatMap((Function1 & Serializable & scala.Serializable)title -> ((Either)MODULE$.readTaskStatus().apply(obj)).map((Function1 & Serializable & scala.Serializable)status -> {
            boolean hasDependencies = BoxesRunTime.unboxToBoolean((Object)((Either)MODULE$.getElements("dependencies").apply(obj)).map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.nonEmpty())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
            return new Tuple2(status, (Object)BoxesRunTime.boxToBoolean((boolean)hasDependencies));
        }).map((Function1 & Serializable & scala.Serializable)x$20 -> {
            Tuple2 tuple2 = x$20;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TaskStatus status = (TaskStatus)tuple2._1();
            boolean hasDependencies = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = new Tuple2((Object)new Task((Task.ID)id, (String)title, (String)taskType, hasDependencies), (Object)status);
            return tuple22;
        })))), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public Function1<JsValue, Either<DeserializationException, TaskStatus>> toTaskStatus() {
        return (Function1 & Serializable & scala.Serializable)json -> MODULE$.convert((JsValue)json, (JsonReader)TaskStatus$.MODULE$.taskStatusFormat());
    }

    public Function1<JsValue, Either<DeserializationException, ReleaseStatus>> toReleaseStatus() {
        return (Function1 & Serializable & scala.Serializable)json -> MODULE$.convert((JsValue)json, (JsonReader)ReleaseStatus$.MODULE$.releaseStatusFormat());
    }

    public Function1<String, Either<DeserializationException, Folder.ID>> parseFolderId(String sep) {
        return (Function1 & Serializable & scala.Serializable)fullId -> {
            String[] stringArray = fullId.split(sep);
            Either either = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)).forall(MODULE$.isFolderId()) ? EitherIdOps$.MODULE$.asRight$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)new Folder.ID(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)).mkString("/")))) : MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"parseFolderId: not a Folder ID: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullId})), MODULE$.error$default$2(), MODULE$.error$default$3());
            return either;
        };
    }

    public String parseFolderId$default$1() {
        return "/";
    }

    public Function1<String, Either<DeserializationException, Phase.ID>> parsePhaseId(String sep) {
        return (Function1 & Serializable & scala.Serializable)fullId -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.splitIntoReleaseIdAndRest((String)fullId, sep), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), (Function1 & Serializable & scala.Serializable)x0$8 -> {
            Tuple2 tuple2 = x0$8;
            if (tuple2 == null) return MODULE$.parsePhaseIdError((String)fullId);
            Release.ID releaseId = (Release.ID)tuple2._1();
            List list = (List)tuple2._2();
            if (!(list instanceof .colon.colon)) return MODULE$.parsePhaseIdError((String)fullId);
            .colon.colon colon2 = (.colon.colon)list;
            String phaseId = (String)colon2.head();
            List list2 = colon2.tl$access$1();
            if (!Nil$.MODULE$.equals(list2)) return MODULE$.parsePhaseIdError((String)fullId);
            if (!BoxesRunTime.unboxToBoolean((Object)MODULE$.isPhaseId().apply((Object)phaseId))) return MODULE$.parsePhaseIdError((String)fullId);
            return EitherIdOps$.MODULE$.asRight$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)new Phase.ID(releaseId, phaseId)));
        }, (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public String parsePhaseId$default$1() {
        return "/";
    }

    public Function1<String, Either<DeserializationException, Task.ID>> parseTaskId(String sep) {
        return (Function1 & Serializable & scala.Serializable)fullId -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.splitIntoReleaseIdAndRest((String)fullId, sep), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), (Function1 & Serializable & scala.Serializable)x0$9 -> {
            Tuple2 tuple2 = x0$9;
            if (tuple2 == null) return MODULE$.parseTaskIdError((String)fullId);
            Release.ID releaseId = (Release.ID)tuple2._1();
            List list = (List)tuple2._2();
            if (!(list instanceof .colon.colon)) return MODULE$.parseTaskIdError((String)fullId);
            .colon.colon colon2 = (.colon.colon)list;
            String phaseId = (String)colon2.head();
            List taskId = colon2.tl$access$1();
            if (!BoxesRunTime.unboxToBoolean((Object)MODULE$.isPhaseId().apply((Object)phaseId))) return MODULE$.parseTaskIdError((String)fullId);
            if (!taskId.forall(MODULE$.isTaskId())) return MODULE$.parseTaskIdError((String)fullId);
            return EitherIdOps$.MODULE$.asRight$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)new Task.ID(new Phase.ID(releaseId, phaseId), taskId.mkString("/"))));
        }, (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public String parseTaskId$default$1() {
        return "/";
    }

    public Function1<String, Either<DeserializationException, Dependency.ID>> parseDependencyId(String sep) {
        return (Function1 & Serializable & scala.Serializable)fullId -> (Either)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(MODULE$.splitIntoReleaseIdAndRest((String)fullId, sep), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither()), arg_0 -> JsUtils$.$anonfun$parseDependencyId$2(fullId, arg_0), (FlatMap)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public String parseDependencyId$default$1() {
        return "/";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Either<DeserializationException, Tuple2<Release.ID, List<String>>> splitIntoReleaseIdAndRest(String id, String sep) {
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])id.split(sep))).toList().span(this.isFolderId());
        if (tuple2 == null) return this.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"splitIntoReleaseIdAndRest: does not contain Release ID: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})), this.error$default$2(), this.error$default$3());
        List folderParts = (List)tuple2._1();
        List list = (List)tuple2._2();
        if (!(list instanceof .colon.colon)) return this.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"splitIntoReleaseIdAndRest: does not contain Release ID: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})), this.error$default$2(), this.error$default$3());
        .colon.colon colon2 = (.colon.colon)list;
        String releasePart = (String)colon2.head();
        List otherParts = colon2.tl$access$1();
        if (!BoxesRunTime.unboxToBoolean((Object)this.isReleaseId().apply((Object)releasePart))) return this.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"splitIntoReleaseIdAndRest: does not contain Release ID: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})), this.error$default$2(), this.error$default$3());
        Release.ID releaseId = new Release.ID(((TraversableOnce)folderParts.$colon$plus((Object)releasePart, List$.MODULE$.canBuildFrom())).mkString("/"));
        return EitherIdOps$.MODULE$.asRight$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)new Tuple2((Object)releaseId, (Object)otherParts)));
    }

    public Function1<String, Object> isFolderId() {
        return (Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)x$21.startsWith("Folder"));
    }

    public Function1<String, Object> isReleaseId() {
        return (Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)x$22.startsWith("Release"));
    }

    public Function1<String, Object> isPhaseId() {
        return (Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)x$23.startsWith("Phase"));
    }

    public Function1<String, Object> isTaskId() {
        return (Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)x$24.startsWith("Task"));
    }

    public <A> Either<DeserializationException, A> parsePhaseIdError(String fullId) {
        return this.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"parsePhaseId: not a Phase ID: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullId})), this.error$default$2(), this.error$default$3());
    }

    public <A> Either<DeserializationException, A> parseTaskIdError(String fullId) {
        return this.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"parseTaskId: not a Task ID: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullId})), this.error$default$2(), this.error$default$3());
    }

    public <A> Either<DeserializationException, A> parseDependencyIdError(String str) {
        return this.error("parseDependencyId: not a Dependency ID: $fullId", this.error$default$2(), this.error$default$3());
    }

    public <A> Either<DeserializationException, A> notFound(String msg, String key, JsValue actual) {
        return this.err(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Not found, key: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg, key})), actual, this.err$default$3());
    }

    public <A> Either<DeserializationException, A> wrongType(String msg, String expected, JsValue actual) {
        return this.err(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Wrong type: ", "(actual), expected: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg, this.jsType(), expected})), actual, this.err$default$3());
    }

    public <A> Either<DeserializationException, A> error(String msg, Option<JsValue> original, List<String> fieldNames) {
        return EitherIdOps$.MODULE$.asLeft$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)new DeserializationException(msg, (Throwable)original.map((Function1 & Serializable & scala.Serializable)jsValue -> MODULE$.debug(msg, (JsValue)jsValue)).orNull(Predef$.MODULE$.$conforms()), fieldNames)));
    }

    public <A> Either<DeserializationException, A> err(String msg, JsValue original, List<String> fieldNames) {
        return this.error(msg, (Option<JsValue>)new Some((Object)original), fieldNames);
    }

    public <A> List<String> err$default$3() {
        return Nil$.MODULE$;
    }

    public <A> Option<JsValue> error$default$2() {
        return None$.MODULE$;
    }

    public <A> List<String> error$default$3() {
        return Nil$.MODULE$;
    }

    public SerializationException debug(String msg, JsValue jsValue) {
        return new SerializationException(msg + "\n" + jsValue.prettyPrint());
    }

    public <A extends JsValue> Function1<JsValue, String> jsType() {
        return (Function1 & Serializable & scala.Serializable)x0$11 -> {
            String string;
            JsValue jsValue = x0$11;
            if (jsValue instanceof JsObject) {
                string = "JsObject";
            } else if (jsValue instanceof JsArray) {
                string = "JsArray";
            } else if (jsValue instanceof JsString) {
                string = "JsString";
            } else if (jsValue instanceof JsNumber) {
                string = "JsNumber";
            } else if (jsValue instanceof JsBoolean) {
                string = "JsBoolean";
            } else if (JsNull$.MODULE$.equals(jsValue)) {
                string = "JsNull";
            } else {
                throw new MatchError((Object)jsValue);
            }
            return string;
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <A> Either<DeserializationException, A> convert(JsValue json, JsonReader<A> reader) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> json.convertTo(reader));
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable d = failure.exception();
            if (d instanceof DeserializationException) {
                DeserializationException deserializationException = (DeserializationException)d;
                return EitherIdOps$.MODULE$.asLeft$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)deserializationException));
            }
        }
        if (bl) {
            Throwable err = failure.exception();
            return EitherIdOps$.MODULE$.asLeft$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)new DeserializationException("JSON format error", err, DeserializationException$.MODULE$.apply$default$3())));
        }
        if (!(try_ instanceof Success)) throw new MatchError((Object)try_);
        Success success = (Success)try_;
        Object a = success.value();
        return EitherIdOps$.MODULE$.asRight$extension(implicits$.MODULE$.catsSyntaxEitherId(a));
    }

    public static final /* synthetic */ boolean $anonfun$matchesTaskStatus$1(TaskStatus expectedStatus$1, JsValue json) {
        return ((Either)MODULE$.readFirstTaskStatus().apply((Object)json)).contains((Object)expectedStatus$1);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Either $anonfun$parseDependencyId$2(String fullId$3, Tuple2 x0$10) {
        block3: {
            block2: {
                var4_2 = x0$10;
                if (var4_2 == null) break block2;
                releaseId = (Release.ID)var4_2._1();
                var6_4 = (List)var4_2._2();
                if (!(var6_4 instanceof .colon.colon)) break block2;
                var7_5 = (.colon.colon)var6_4;
                phaseId = (String)var7_5.head();
                taskIdAndDependency = var7_5.tl$access$1();
                if (!BoxesRunTime.unboxToBoolean((Object)JsUtils$.MODULE$.isPhaseId().apply((Object)phaseId))) break block2;
                var10_8 = taskIdAndDependency.span(JsUtils$.MODULE$.isTaskId());
                if (var10_8 == null) ** GOTO lbl-1000
                taskIds = (List)var10_8._1();
                var12_10 = (List)var10_8._2();
                if (!(var12_10 instanceof .colon.colon)) ** GOTO lbl-1000
                var13_11 = (.colon.colon)var12_10;
                dependencyId = (String)var13_11.head();
                var15_13 = var13_11.tl$access$1();
                if (Nil$.MODULE$.equals(var15_13) && taskIds.nonEmpty()) {
                    phase = new Phase.ID(releaseId, phaseId);
                    task = new Task.ID(phase, taskIds.mkString("/"));
                    var3_16 = EitherIdOps$.MODULE$.asRight$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)new Dependency.ID(task, dependencyId)));
                } else lbl-1000:
                // 3 sources

                {
                    var3_16 = JsUtils$.MODULE$.parseDependencyIdError(fullId$3);
                }
                var2_17 = var3_16;
                break block3;
            }
            var2_17 = JsUtils$.MODULE$.parseDependencyIdError(fullId$3);
        }
        return var2_17;
    }

    private JsUtils$() {
        MODULE$ = this;
    }
}

