package com.xebialabs.xlrelease.stress.dsl.libs.xlr

import com.xebialabs.xlrelease.stress.config.XlrServer
import com.xebialabs.xlrelease.stress.domain.{User, Variable}
import com.xebialabs.xlrelease.stress.dsl.DSL
import com.xebialabs.xlrelease.stress.utils.JsUtils
import freestyle.free._
import spray.json._


class Configurations[F[_]](server: XlrServer)(implicit protected val _api: DSL[F])
  extends XlrLib[F] with DefaultJsonProtocol {
  self =>

  def createGlobalVariable[T](variable: Variable[T])
                             (implicit session: User.Session): Program[Variable.ID] =
    for {
      _ <- log.debug(s"xlr.globalVariables.createGlobalVariable($variable)")
      resp <- lib.http.json.post(server.api(_ ?/ "config" / "Configuration" / "variables" / "global"),
        variable.toJson
      )
      content <- api.http.parseJson(resp)
      variableId <- lib.json.read(JsUtils.readIdString)(content)
    } yield Variable.ID(None, variableId)

  def deleteGlobalVariable(variableId: Variable.ID)
                          (implicit session: User.Session): Program[Unit] =
    for {
      _ <- log.debug(s"xlr.configurations.deleteGlobalVariable($variableId)")
      resp <- lib.http.delete(server.api(_ ?/ "config" ++ variableId.path))
      _ <- api.http.discard(resp)
    } yield ()

}
