package com.xebialabs.xlrelease.stress

import akka.http.scaladsl.model.Uri

package object domain {

  def asPath(id: String): Uri.Path = {
    val elements = id.split("[/-]").toList
    elements.tail.foldLeft[Uri.Path](Uri.Path / elements.head) {
      case (l, r) => l / r
    }
  }

}
