package com.xebialabs.xlrelease.stress.domain

import akka.http.scaladsl.model.Uri
import cats.Show
import cats.implicits._
import spray.json._

case class Variable[T](id: Variable.ID,
                       key: String,
                       variableType: String,
                       value: Option[T],
                       required: Boolean = false,
                       showOnReleaseStart: Boolean = false)
                      (implicit val writer: JsonWriter[T])

object Variable extends DefaultJsonProtocol {

  case class ID(release: Option[Release.ID], id: String)

  object ID {
    implicit val showVariableID: Show[ID] = {
      case ID(None, id) => id
      case ID(Some(releaseId), id) => s"${releaseId.show}/$id"
    }

    val empty = ID(None, "")
  }

  def mapStringString(id: Variable.ID,
                      key: String,
                      value: Option[Map[String, String]],
                      required: Boolean = false,
                      showOnReleaseStart: Boolean = false): Variable[Map[String, String]] =
    Variable(id, key, "xlrelease.MapStringStringVariable", value, required, showOnReleaseStart)

  implicit def jsonWriter[T]: JsonWriter[Variable[T]] = {
    v =>
      JsObject(
        "id" -> v.id.show.toJson,
        "key" -> v.key.toJson,
        "type" -> v.variableType.toJson,
        "value" -> v.value.map(v.writer.write).toJson,
        "requiresValue" -> v.required.toJson,
        "showOnReleaseStart" -> v.showOnReleaseStart.toJson
      )
  }

  implicit class VariableIDOps(val id: Variable.ID) extends AnyVal {
    def path: Uri.Path = asPath(id.show)
  }

}
