package com.xebialabs.xlrelease.stress.domain

import akka.http.scaladsl.model.Uri
import cats.Show
import cats.implicits._

case class Task(id: Task.ID, title: String, taskType: String, hasDependencies: Boolean = false) {
  def isManual: Boolean =
    taskType == "xlrelease.Task" ||
      taskType == "xlrelease.GateTask" && !hasDependencies ||
      taskType == "xlrelease.UserInputTask"
}

object Task {
  case class ID(phaseId: Phase.ID, task: String)

  implicit def showTaskId(implicit sp: Show[Phase.ID]): Show[Task.ID] = {
    case ID(phaseId, taskId) => s"${sp.show(phaseId)}/$taskId"
  }

  implicit class TaskIDOps(val id: Task.ID) extends AnyVal {
    def release: Release.ID = id.phaseId.release
    def path: Uri.Path = asPath(id.show)
  }

}