package com.xebialabs.xlrelease.stress.domain

import akka.http.scaladsl.model.Uri
import cats.Show
import cats.implicits._

object Release {
  case class ID(id: String)

  implicit val showReleaseId: Show[Release.ID] = {
    case ID(id) => id
  }

  implicit class ReleaseIDOps(val id: Release.ID) extends AnyVal {
    def path: Uri.Path = asPath(id.show)
  }

}

