package com.xebialabs.xlrelease.stress.domain

import akka.http.scaladsl.model.Uri
import cats.Show
import cats.implicits._

case class Folder(name: String, parent: Option[Folder], id: Folder.ID)

object Folder {

  case class ID(id: String)

  implicit val showFolderId: Show[Folder.ID] = {
    case ID(id) => id
  }

  implicit class FolderIDOps(val id: Folder.ID) extends AnyVal {
    def path: Uri.Path = asPath(id.show)
  }

}
