/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.zendesk.services;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.zendesk.ZendeskCrawler;
import com.xebialabs.agatha.crawlers.zendesk.ZendeskUrlHelper;
import com.xebialabs.agatha.crawlers.zendesk.ZendeskUtil;
import com.xebialabs.agatha.crawlers.zendesk.messages.ZendeskTicketMessage;
import com.xebialabs.agatha.crawlers.zendesk.messages.ZendeskTicketsMessage;
import com.xebialabs.agatha.crawlers.zendesk.models.ZendeskBaseEntity;
import com.xebialabs.agatha.crawlers.zendesk.models.ZendeskTicket;
import com.xebialabs.agatha.crawlers.zendesk.models.dtos.TicketsResponse;
import com.xebialabs.agatha.crawlers.zendesk.services.ZendeskBaseCrawl;
import com.xebialabs.agatha.crawlers.zendesk.transform.converters.TicketConverter;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZendeskTicketsCrawl
extends ZendeskBaseCrawl<ZendeskTicketsMessage, TicketsResponse> {
    private static final Logger logger = LoggerFactory.getLogger(ZendeskTicketsCrawl.class);

    public ZendeskTicketsCrawl(ZendeskCrawler crawler, ZendeskTicketsMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage);
    }

    protected CrawledDataWrappedResponse<TicketsResponse> processMessage() throws CrawlerWorkException {
        logger.debug("Process ZendeskTicketsMessage for url {} , page - {}, limit - {}, lastUpdatedDate - {}", new Object[]{((ZendeskTicketsMessage)this.message).getBaseUrl(), ((ZendeskTicketsMessage)this.message).getPage(), ((ZendeskTicketsMessage)this.message).getLimit(), ((ZendeskTicketsMessage)this.message).getLastUpdatedDate()});
        URL ticketsUrl = ZendeskUrlHelper.ticketsUrl(((ZendeskTicketsMessage)this.message).getBaseUrl(), ((ZendeskTicketsMessage)this.message).getPage(), ((ZendeskTicketsMessage)this.message).getLimit(), ZendeskUtil.crawlDateFrom(this.validDate), ((ZendeskTicketsMessage)this.message).getLastUpdatedDate());
        CrawledDataWrappedResponse response = this.responseFetcher.fetchEntity(TicketsResponse.class, ticketsUrl);
        this.handleReponse((CrawledDataWrappedResponse<TicketsResponse>)response);
        return response;
    }

    private void handleReponse(CrawledDataWrappedResponse<TicketsResponse> response) throws CrawlerWorkException {
        TicketsResponse ticketsResponse = (TicketsResponse)response.getEntity();
        if (ticketsResponse.isEmpty()) {
            logger.debug("No records found for lastUpdatedDate - {} with limit - {}, page - {}", new Object[]{((ZendeskTicketsMessage)this.message).getLastUpdatedDate(), ((ZendeskTicketsMessage)this.message).getLimit(), ((ZendeskTicketsMessage)this.message).getPage()});
            return;
        }
        int matchedVersions = 0;
        List<ZendeskTicket> result = ticketsResponse.getResults();
        for (ZendeskTicket entity : result) {
            matchedVersions += this.sendTicketMessage(entity);
        }
        if (this.isCountLessThanLimit(ticketsResponse)) {
            return;
        }
        this.handleNextMessage(ticketsResponse, matchedVersions);
    }

    private int sendTicketMessage(ZendeskTicket entity) throws CrawlerWorkException {
        try {
            if (this.entityAlreadyCrawled(entity)) {
                return 1;
            }
            ((ZendeskCrawler)this.crawler).sendCrawlerTaskMessage(this.createDataMessage(ZendeskTicketMessage.class.getSimpleName(), this.ticketMessage(entity)));
            return 0;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    private boolean entityAlreadyCrawled(ZendeskTicket entity) throws CrawlerWorkException {
        return !((ZendeskCrawler)this.crawler).decideToContinueBeforeCrawling(this.dataMessage, ZendeskUtil.dateAsLong(entity.getUpdatedAt()) + "", TicketConverter.artifactId(entity.getId()), DataSourceTypeEnum.TICKET);
    }

    private ZendeskTicketMessage ticketMessage(ZendeskTicket entity) throws InstantiationException, IllegalAccessException {
        return ((ZendeskCrawler)this.crawler).generateNewMessage(ZendeskTicketMessage.class, this.message).setTicketId(entity.getId());
    }

    private boolean isCountLessThanLimit(TicketsResponse response) {
        return response.getCount() <= ((ZendeskTicketsMessage)this.message).getLimit();
    }

    private void handleNextMessage(TicketsResponse response, int matchedVersions) throws CrawlerWorkException {
        if (((ZendeskTicketsMessage)this.message).getLastUpdatedDate() == null || ((ZendeskTicketsMessage)this.message).getLastUpdatedDate().isEmpty()) {
            String updatedGreaterThan = this.lastUpdatedDate(response);
            if (updatedGreaterThan.isEmpty()) {
                this.sendMessageWithGreaterMaxLimit((ZendeskTicketsMessage)this.message);
            } else {
                this.sendMessageWithLastUpdatedDate(updatedGreaterThan);
            }
            return;
        }
        if (((ZendeskTicketsMessage)this.message).getPage() == 1) {
            matchedVersions = 0;
        }
        int size = response.getResults().size();
        if (!(((ZendeskTicketsMessage)this.message).getLimit() != size || ((ZendeskTicketsMessage)this.message).getMetadata().isIncremental() && matchedVersions >= size)) {
            this.sendNextPageMessage((ZendeskTicketsMessage)this.message, response);
        }
    }

    private String lastUpdatedDate(TicketsResponse response) {
        List<ZendeskTicket> result = response.getResults();
        List values = result.stream().map(ZendeskBaseEntity::getUpdatedAt).distinct().sorted().collect(Collectors.toList());
        if (values.size() < 2) {
            return "";
        }
        logger.debug("Last Updated date for message - {}, lastUpdatedDate - {} ", (Object)((Object)((Object)((ZendeskTicketsMessage)this.message))).getClass().getSimpleName(), values.get(1));
        return (String)values.get(1);
    }

    private void sendNextPageMessage(ZendeskTicketsMessage message, TicketsResponse response) throws CrawlerWorkException {
        ZendeskTicketsMessage newMessage = this.newTicketsMessage();
        newMessage.setPage(message.getPage() + 1).setLastUpdatedDate(message.getLastUpdatedDate());
        logger.debug("Send Next Page message with page - {}, lastUpdatedDate - {}  ", (Object)newMessage.getPage(), (Object)newMessage.getLastUpdatedDate());
        ((ZendeskCrawler)this.crawler).sendCrawlerTaskMessage(this.newDataMessage(newMessage));
    }

    private void sendMessageWithLastUpdatedDate(String updatedGreaterThan) throws CrawlerWorkException {
        ZendeskTicketsMessage newMessage = this.newTicketsMessage();
        newMessage.setPage(1).setLastUpdatedDate(updatedGreaterThan);
        logger.debug("Send Message with lastupdateddate - {} ", (Object)updatedGreaterThan);
        ((ZendeskCrawler)this.crawler).sendCrawlerTaskMessage(this.newDataMessage(newMessage));
    }

    private void sendMessageWithGreaterMaxLimit(ZendeskTicketsMessage message) throws CrawlerWorkException {
        ZendeskTicketsMessage newMessage = this.newTicketsMessage();
        newMessage.setPage(1).setLimit(message.getLimit() + 10);
        logger.debug("Send message with greater max limit with limit - {} ", (Object)newMessage.getLimit());
        ((ZendeskCrawler)this.crawler).sendCrawlerTaskMessage(this.newDataMessage(newMessage));
    }

    private BaseCrawlerMessage newDataMessage(ZendeskTicketsMessage newMessage) {
        return this.createDataMessage(((Object)((Object)newMessage)).getClass().getSimpleName(), newMessage);
    }

    private ZendeskTicketsMessage newTicketsMessage() throws CrawlerWorkException {
        try {
            return ((ZendeskCrawler)this.crawler).generateNewMessage(ZendeskTicketsMessage.class, this.message);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }
}

