/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.zendesk.services;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.repository.KeyValueRepository;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.agatha.crawlers.zendesk.ZendeskCrawler;
import com.xebialabs.agatha.crawlers.zendesk.ZendeskUrlHelper;
import com.xebialabs.agatha.crawlers.zendesk.messages.ZendeskCustomFieldsMessage;
import com.xebialabs.agatha.crawlers.zendesk.messages.ZendeskTicketsMessage;
import com.xebialabs.agatha.crawlers.zendesk.models.dtos.CustomFieldResponse;
import com.xebialabs.agatha.crawlers.zendesk.repository.CustomFieldRepository;
import com.xebialabs.agatha.crawlers.zendesk.services.ZendeskBaseCrawl;
import com.xebialabs.agatha.crawlers.zendesk.transform.converters.CustomFieldConverter;
import com.xebialabs.agatha.crawlers.zendesk.transform.models.CustomFieldUM;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZendeskCustomFieldsCrawl
extends ZendeskBaseCrawl<ZendeskCustomFieldsMessage, CustomFieldResponse> {
    private static final Logger logger = LoggerFactory.getLogger(ZendeskCustomFieldsCrawl.class);
    private final UMConverter<CustomFieldUM, CustomFieldResponse> converter = new CustomFieldConverter("ZendeskPlugin", "v1", "FIELDS", "v1");
    private final KeyValueRepository<CustomFieldUM> repository;

    public ZendeskCustomFieldsCrawl(ZendeskCrawler crawler, ZendeskCustomFieldsMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage);
        this.repository = new CustomFieldRepository(crawler, dataMessage);
    }

    protected CrawledDataWrappedResponse<CustomFieldResponse> processMessage() throws CrawlerWorkException {
        logger.debug("Process ZendeskCustomFieldsMessage for URL {}.", (Object)((ZendeskCustomFieldsMessage)this.message).getBaseUrl());
        CrawledDataWrappedResponse response = this.responseFetcher.fetchEntity(CustomFieldResponse.class, ZendeskUrlHelper.ticketFieldsUrl(((ZendeskCustomFieldsMessage)this.message).getBaseUrl()));
        this.handleResponse((CrawledDataWrappedResponse<CustomFieldResponse>)response);
        return response;
    }

    private void handleResponse(CrawledDataWrappedResponse<CustomFieldResponse> response) throws CrawlerWorkException {
        this.saveCustomFields((CustomFieldResponse)((Object)response.getEntity()));
        this.sendMessage(ZendeskTicketsMessage.class);
    }

    private void saveCustomFields(CustomFieldResponse entity) throws CrawlerWorkException {
        UMWrappedEntity umWrappedEntity = this.converter.convert((Object)entity);
        this.repository.save(umWrappedEntity);
    }
}

