/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.shared.components;

import com.xebialabs.agatha.crawlers.AbstractHttpCrawler;
import com.xebialabs.agatha.crawlers.ResponseEntity;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseFetcher<C extends AbstractHttpCrawler> {
    private static final Logger logger = LoggerFactory.getLogger(ResponseFetcher.class);
    protected final C crawler;

    public ResponseFetcher(C crawler) {
        this.crawler = crawler;
    }

    protected Request buildRequest(URL url) {
        return new Request.Builder().url(url).build();
    }

    public String responseAsContent(URL url) throws CrawlerWorkException {
        return this.crawler.getResponseBody(this.buildRequest(url));
    }

    private String content(URL url) throws CrawlerWorkException {
        return this.responseAsContent(url);
    }

    protected <R> R entity(Class<R> clazz, String content) throws IOException {
        return (R)this.crawler.getMapper().readValue(content, clazz);
    }

    protected ResponseEntity responseAsEntity(URL url) throws CrawlerWorkException {
        return this.crawler.getResponseAsEntity(this.buildRequest(url));
    }

    public <R> CrawledDataWrappedResponse<R> fetchEntity(Class<R> clazz, URL url) throws CrawlerWorkException {
        return this.fetch(clazz, url);
    }

    public <R> CrawledDataWrappedResponse<R> fetch(Class<R> clazz, URL url) throws CrawlerWorkException {
        String content = null;
        try {
            content = this.content(url);
            R entity = this.entity(clazz, content);
            return new CrawledDataWrappedResponse<R>(entity, content);
        }
        catch (IOException e) {
            logger.error("Error occurred in fetch for Url - {}, with Response - {}", (Object)url, (Object)content);
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    public CrawledDataWrappedResponse<Void> fetchContent(URL url) throws CrawlerWorkException {
        return new CrawledDataWrappedResponse<Void>(this.content(url));
    }

    public Reader responseAsStream(URL url) throws CrawlerWorkException {
        return this.crawler.getResponseBodyAsStream(this.buildRequest(url));
    }
}

