/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.zendesk.services;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.repository.KeyValueRepository;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.agatha.crawlers.zendesk.ZendeskCrawler;
import com.xebialabs.agatha.crawlers.zendesk.ZendeskUrlHelper;
import com.xebialabs.agatha.crawlers.zendesk.messages.ZendeskTicketMessage;
import com.xebialabs.agatha.crawlers.zendesk.models.dtos.TicketResponse;
import com.xebialabs.agatha.crawlers.zendesk.repository.TicketRepository;
import com.xebialabs.agatha.crawlers.zendesk.services.ZendeskBaseCrawl;
import com.xebialabs.agatha.crawlers.zendesk.transform.converters.TicketConverter;
import com.xebialabs.agatha.crawlers.zendesk.transform.models.Ticket;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZendeskTicketCrawl
extends ZendeskBaseCrawl<ZendeskTicketMessage, TicketResponse> {
    private static final Logger logger = LoggerFactory.getLogger(ZendeskTicketCrawl.class);
    private final UMConverter<Ticket, TicketResponse> converter = new TicketConverter("ZendeskPlugin", "v1", "TICKET", "v1");
    private final KeyValueRepository<Ticket> repository;

    public ZendeskTicketCrawl(ZendeskCrawler crawler, ZendeskTicketMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage);
        this.repository = new TicketRepository(crawler, dataMessage);
    }

    protected CrawledDataWrappedResponse<TicketResponse> processMessage() throws CrawlerWorkException {
        logger.debug("Process ZendeskTicketMessage for Ticket Id {}", (Object)((ZendeskTicketMessage)this.message).getTicketId());
        CrawledDataWrappedResponse response = this.responseFetcher.fetchEntity(TicketResponse.class, ZendeskUrlHelper.ticketUrl(((ZendeskTicketMessage)this.message).getBaseUrl(), ((ZendeskTicketMessage)this.message).getTicketId()));
        this.handleResponse((CrawledDataWrappedResponse<TicketResponse>)response);
        return response;
    }

    private void handleResponse(CrawledDataWrappedResponse<TicketResponse> response) throws CrawlerWorkException {
        UMWrappedEntity umWrappedEntity = this.converter.convert(response.getEntity());
        this.repository.save(umWrappedEntity);
    }
}

