#!/bin/sh
set -e
set -a

cd $(dirname $0)

PLUGINNAME=zendesk

CONFDIR="."
while true ; do
    echo "checking $(cd "$CONFDIR" && pwd)"
    if [ -d "$CONFDIR/conf" ]; then
        echo "found conf dir in $(cd "$CONFDIR/conf" && pwd)"
        [ -f "$CONFDIR/conf/xli-defaults.env" ] && echo "applying $(cd "$CONFDIR" && pwd)/conf/xli-defaults.env" && . "$CONFDIR/conf/xli-defaults.env"
        [ -f "$CONFDIR/conf/$PLUGINNAME-plugin.env" ] && echo "applying $(cd "$CONFDIR" && pwd)/conf/$PLUGINNAME-plugin.env" && . "$CONFDIR/conf/$PLUGINNAME-plugin.env"
        [ -f "$CONFDIR/conf/xli-defaults.env" ] && echo "xli-defaults.env found, so no more checks" && break
    fi;
    if [ "$(cd "$CONFDIR" && cd .. && pwd)" = "$(cd "$CONFDIR" && pwd)" ] ; then break; fi
    CONFDIR="../$CONFDIR" ;
done

exec ./bin/$PLUGINNAME
