/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.travis.services.probe;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.travis.TravisURLHelper;
import com.xebialabs.agatha.crawlers.travis.services.probe.ProbeService;
import com.xebialabs.impact.api.ProbeResultMetadataVM;
import java.io.IOException;
import java.net.URL;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class ProbeServiceImpl
implements ProbeService {
    private final URL endpoint;
    private final OkHttpClient client;
    private final ProbeResultMetadataVM result;

    public ProbeServiceImpl(URL endpoint, OkHttpClient client, String username) {
        this.endpoint = endpoint;
        this.client = client;
        this.result = new ProbeResultMetadataVM().setEndpoint(endpoint.toString()).setUsername(username);
    }

    @Override
    public ProbeResultMetadataVM probe() {
        try {
            Response response = this.response(this.request());
            if (response.isSuccessful()) {
                return this.result.setSuccess(true);
            }
            return this.result.setSuccess(false).setReason("Status: " + response.code());
        }
        catch (IOException e) {
            return this.result.setSuccess(false).setReason(e.getMessage());
        }
        catch (CrawlerWorkException e) {
            return this.result.setSuccess(false).setReason(e.getMessage());
        }
    }

    private Request request() throws CrawlerWorkException {
        return new Request.Builder().url(TravisURLHelper.probeUrl(this.endpoint)).addHeader("Travis-API-Version", "3").build();
    }

    private Response response(Request request) throws IOException {
        return this.client.newCall(request).execute();
    }
}

