/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.travis.components;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.BaseCrawlFactory;
import com.xebialabs.agatha.crawlers.shared.components.CrawlService;
import com.xebialabs.agatha.crawlers.travis.TravisCrawler;
import com.xebialabs.agatha.crawlers.travis.messages.TravisBuildJobMessage;
import com.xebialabs.agatha.crawlers.travis.messages.TravisBuildJobsMessage;
import com.xebialabs.agatha.crawlers.travis.messages.TravisBuildMessage;
import com.xebialabs.agatha.crawlers.travis.messages.TravisBuildsMessage;
import com.xebialabs.agatha.crawlers.travis.messages.TravisJobMessage;
import com.xebialabs.agatha.crawlers.travis.services.TravisBuildCrawl;
import com.xebialabs.agatha.crawlers.travis.services.TravisBuildJobCrawl;
import com.xebialabs.agatha.crawlers.travis.services.TravisBuildJobsCrawl;
import com.xebialabs.agatha.crawlers.travis.services.TravisBuildsCrawl;
import com.xebialabs.agatha.crawlers.travis.services.TravisJobCrawl;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.io.IOException;

public class TravisCrawlFactory
extends BaseCrawlFactory<TravisCrawler> {
    private CrawlService buildJobCrawl(TravisCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new TravisBuildJobCrawl(crawler, (TravisBuildJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, TravisBuildJobMessage.class)), crawlerDataMessage);
    }

    private CrawlService buildJobsCrawl(TravisCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new TravisBuildJobsCrawl(crawler, (TravisBuildJobsMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, TravisBuildJobsMessage.class)), crawlerDataMessage);
    }

    private CrawlService buildCrawl(TravisCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new TravisBuildCrawl(crawler, (TravisBuildMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, TravisBuildMessage.class)), crawlerDataMessage);
    }

    private CrawlService buildsCrawl(TravisCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new TravisBuildsCrawl(crawler, (TravisBuildsMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, TravisBuildsMessage.class)), crawlerDataMessage);
    }

    private CrawlService jobCrawl(TravisCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new TravisJobCrawl(crawler, (TravisJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, TravisJobMessage.class)), crawlerDataMessage);
    }

    public CrawlService getInstance(TravisCrawler crawler, BaseCrawlerMessage message) throws CrawlerWorkException {
        CrawlService crawlService;
        try {
            switch (message.getDataKey().toLowerCase()) {
                case "travisjobmessage": {
                    crawlService = this.jobCrawl(crawler, message);
                    break;
                }
                case "travisbuildsmessage": {
                    crawlService = this.buildsCrawl(crawler, message);
                    break;
                }
                case "travisbuildmessage": {
                    crawlService = this.buildCrawl(crawler, message);
                    break;
                }
                case "travisbuildjobsmessage": {
                    crawlService = this.buildJobsCrawl(crawler, message);
                    break;
                }
                case "travisbuildjobmessage": {
                    crawlService = this.buildJobCrawl(crawler, message);
                    break;
                }
                default: {
                    throw new CrawlerWorkException("No Crawler implementation found.");
                }
            }
        }
        catch (IOException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
        return crawlService;
    }
}

