/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.travis.transform.converters;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.PluginConstants;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.agatha.crawlers.travis.TravisUtil;
import com.xebialabs.agatha.crawlers.travis.models.BaseBuild;
import com.xebialabs.agatha.crawlers.travis.transform.models.BuildUM;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.util.HashMap;

public abstract class BaseBuildConverter<B extends BaseBuild>
implements UMConverter<BuildUM, B> {
    private final String pluginId;
    private final String pluginVersion;
    private final String type;
    private final String typeVersion;
    private final String entityType;
    private String organization;

    protected BaseBuildConverter(String pluginId, String pluginVersion, String type, String typeVersion, String entityType) {
        this.pluginId = pluginId;
        this.pluginVersion = pluginVersion;
        this.type = type;
        this.typeVersion = typeVersion;
        this.entityType = entityType;
    }

    private void populateTopLevelFields(BuildUM build, B entity) throws CrawlerWorkException {
        build.setId(((BaseBuild)entity).getId() + "");
        build.setTitle(((BaseBuild)entity).getNumber());
        build.setBuildType(((BaseBuild)entity).getType());
        build.setStartMs(TravisUtil.dateAsLong(((BaseBuild)entity).getStartTime()));
        build.setFinishMs(TravisUtil.dateAsLong(((BaseBuild)entity).getFinishTime()));
        build.setStatus(this.buildStatus(((BaseBuild)entity).getState()));
    }

    private void populateAdditionalFields(BuildUM build, B entity) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("organization", this.organization);
        fields.put("repo", ((BaseBuild)entity).getRepository().getName());
        build.setAdditionalFields(fields);
    }

    private void populateUrlParts(BuildUM build, B entity) {
        HashMap<String, String> urlParts = new HashMap<String, String>();
        urlParts.put("repository", TravisUtil.generateDataId(this.organization, ((BaseBuild)entity).getRepository().getName()));
        urlParts.put("id", ((BaseBuild)entity).getId() + "");
        urlParts.put("type", this.entityType);
        build.setUrlParts(urlParts);
    }

    public UMWrappedEntity<BuildUM> convert(B entity) throws CrawlerWorkException {
        BuildUM build = new BuildUM();
        this.populateTopLevelFields(build, entity);
        this.populateOther(build, entity);
        this.populateAdditionalFields(build, entity);
        this.populateUrlParts(build, entity);
        return this.wrappedEntity(entity, build);
    }

    protected abstract void populateOther(BuildUM var1, B var2) throws CrawlerWorkException;

    private String buildStatus(String state) {
        PluginConstants.BuildStatus buildStatus;
        switch (state.toLowerCase()) {
            case "created": 
            case "received": 
            case "queued": {
                buildStatus = PluginConstants.BuildStatus.PLANNED;
                break;
            }
            case "started": {
                buildStatus = PluginConstants.BuildStatus.RUNNING;
                break;
            }
            case "passed": {
                buildStatus = PluginConstants.BuildStatus.SUCCEEDED;
                break;
            }
            case "failed": 
            case "errored": {
                buildStatus = PluginConstants.BuildStatus.FAILED;
                break;
            }
            case "canceled": {
                buildStatus = PluginConstants.BuildStatus.SKIPPED;
                break;
            }
            default: {
                buildStatus = PluginConstants.BuildStatus.UNKNOWN;
            }
        }
        return buildStatus.name();
    }

    private UMWrappedEntity<BuildUM> wrappedEntity(B entity, BuildUM um) {
        return new UMWrappedEntity(this.pluginId, this.pluginVersion, this.type, this.typeVersion, (Object)um, DataSourceTypeEnum.BUILD).setId(um.getId()).setVersion(((BaseBuild)entity).getUpdatedAt()).wrap();
    }

    public String getOrganization() {
        return this.organization;
    }

    public BaseBuildConverter<B> setOrganization(String organization) {
        this.organization = organization;
        return this;
    }
}

