/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.travis;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.travis.messages.TravisBuildJobMessage;
import com.xebialabs.agatha.crawlers.travis.messages.TravisBuildJobsMessage;
import com.xebialabs.agatha.crawlers.travis.messages.TravisBuildsMessage;
import com.xebialabs.agatha.crawlers.travis.messages.TravisJobMessage;
import java.net.MalformedURLException;
import java.net.URL;
import okhttp3.HttpUrl;

public class TravisURLHelper {
    public static URL probeUrl(URL endpoint) throws CrawlerWorkException {
        return TravisURLHelper.baseUrlBuilder(endpoint.toString()).addPathSegment("orgs").addQueryParameter("limit", "1").build().url();
    }

    private static URL getURL(String endPoint) throws CrawlerWorkException {
        try {
            return new URL(endPoint);
        }
        catch (MalformedURLException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    private static HttpUrl.Builder baseUrlBuilder(String endPoint) throws CrawlerWorkException {
        if (endPoint != null && !endPoint.isEmpty()) {
            URL baseURL = TravisURLHelper.getURL(endPoint);
            HttpUrl.Builder builder = new HttpUrl.Builder().scheme(baseURL.getProtocol()).host(baseURL.getHost());
            if (baseURL.getPort() != -1) {
                builder.port(baseURL.getPort());
            }
            return builder;
        }
        throw new CrawlerWorkException("Base URL can not be empty or null.");
    }

    private static HttpUrl.Builder basePathBuilder(String endPoint, String ... pathSegments) throws CrawlerWorkException {
        HttpUrl.Builder builder = TravisURLHelper.baseUrlBuilder(endPoint);
        for (String path : pathSegments) {
            builder.addPathSegment(path);
        }
        return builder;
    }

    private static URL baseEntitiesURL(String endPoint, int limit, String ... pathSegments) throws CrawlerWorkException {
        HttpUrl.Builder builder = TravisURLHelper.basePathBuilder(endPoint, pathSegments);
        return builder.addQueryParameter("limit", limit + "").build().url();
    }

    public static URL buildUrl(String baseUrl, String suffix) throws CrawlerWorkException {
        URL completeUrl;
        try {
            completeUrl = new URL(new URL(baseUrl), suffix);
        }
        catch (MalformedURLException e) {
            throw new CrawlerWorkException(String.format("URL %s/%s is invalid", baseUrl, suffix), (Throwable)e);
        }
        return completeUrl;
    }

    public static URL reposUrl(TravisJobMessage message) throws CrawlerWorkException {
        if (null == message.getUrl()) {
            return TravisURLHelper.baseEntitiesURL(message.getBaseUrl(), message.getLimit(), "owner", message.getUserName(), "repos");
        }
        return TravisURLHelper.buildUrl(message.getBaseUrl(), message.getUrl());
    }

    public static URL buildsUrl(TravisBuildsMessage message) throws CrawlerWorkException {
        if (null == message.getUrl()) {
            return TravisURLHelper.baseEntitiesURL(message.getBaseUrl(), message.getLimit(), "repo", message.getRepoId() + "", "builds");
        }
        return TravisURLHelper.buildUrl(message.getBaseUrl(), message.getUrl());
    }

    public static URL jobsUrl(TravisBuildJobsMessage message) throws CrawlerWorkException {
        HttpUrl.Builder builder = TravisURLHelper.basePathBuilder(message.getBaseUrl(), "build", message.getBuildId() + "", "jobs");
        return builder.build().url();
    }

    public static URL jobLogUrl(TravisBuildJobMessage message) throws CrawlerWorkException {
        HttpUrl.Builder builder = TravisURLHelper.basePathBuilder(message.getBaseUrl(), "job", message.getJobId() + "", "log");
        return builder.build().url();
    }
}

