/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jira.extractor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.xebialabs.agatha.crawlers.jira.models.Changelog;
import com.xebialabs.agatha.crawlers.jira.models.Issue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ChangelogExtractor {
    private static final String CREATED_DATE = "created";
    private static final String VERSION_CHANGED_BY = "versionChangedBy";
    private static final String VERSION_CHANGED_BY_EMAIL = "versionChangedByEmail";
    private static final List<String> FIELDS_WITH_MEANINGFUL_VALUE = Arrays.asList("votes", "displayName", "name", "description", "key", "value");

    private ChangelogExtractor() {
    }

    private static String extractValue(JsonNode objectNode) {
        if (objectNode == null) {
            return "";
        }
        if (objectNode instanceof TextNode) {
            return objectNode.asText();
        }
        return FIELDS_WITH_MEANINGFUL_VALUE.stream().flatMap(v -> {
            JsonNode node = objectNode.findPath(v);
            if (node.isMissingNode()) {
                return Stream.empty();
            }
            return Stream.of(node.asText());
        }).findFirst().orElse("");
    }

    private static Map<String, String> getVersionRepresentations(JsonNode jsonNode) {
        JsonNode representations = jsonNode.findPath("versionedRepresentations").findPath("properties");
        Iterable versionedRepresentations = () -> ((JsonNode)representations).fieldNames();
        HashMap<String, String> acc = new HashMap<String, String>();
        for (String r : versionedRepresentations) {
            JsonNode node = representations.get(r);
            TreeSet<String[]> versions = new TreeSet<String[]>(Comparator.comparing(o -> o[1]));
            for (int i = 1; i < node.size() + 1; ++i) {
                String v = ChangelogExtractor.getValues(node, String.valueOf(i));
                versions.add(new String[]{r, v});
            }
            if (versions.isEmpty()) continue;
            String[] last = versions.last();
            acc.put(last[0], last[1]);
        }
        return acc;
    }

    public static List<Issue> extractIssues(Issue issue, ObjectMapper mapper) throws IOException {
        List<Changelog.History> histories = issue.getChangelog().getHistories();
        if (histories.isEmpty()) {
            return Collections.singletonList(issue);
        }
        JsonNode jsonNode = (JsonNode)mapper.convertValue((Object)issue, JsonNode.class);
        ArrayList<Issue> issues = new ArrayList<Issue>();
        Map<String, String> lastVersionedReps = ChangelogExtractor.getVersionRepresentations(jsonNode);
        String firstIssueCreatedDate = lastVersionedReps.get(CREATED_DATE);
        lastVersionedReps.remove("updated");
        Issue next = (Issue)((Object)mapper.readValue(mapper.writeValueAsString((Object)issue), Issue.class));
        next.setCleanedVersionRepresentation(lastVersionedReps);
        Changelog.History head = histories.get(0);
        next.getCleanedVersionRepresentation().put(CREATED_DATE, head.getCreated());
        next.getCleanedVersionRepresentation().put(VERSION_CHANGED_BY, head.getAuthor().getDisplayName());
        next.getCleanedVersionRepresentation().put(VERSION_CHANGED_BY_EMAIL, head.getAuthor().getEmailAddress());
        issues.add(next);
        for (int idx = 0; idx < histories.size(); ++idx) {
            Issue oldIssue = ChangelogExtractor.rollBackIssue(histories, next, idx, mapper);
            issues.add(oldIssue);
            next = oldIssue;
        }
        if (!issues.isEmpty()) {
            Issue firstVersion = (Issue)((Object)issues.get(issues.size() - 1));
            firstVersion.getCleanedVersionRepresentation().put(CREATED_DATE, firstIssueCreatedDate);
        }
        return issues;
    }

    private static Issue rollBackIssue(List<Changelog.History> histories, Issue next, int idx, ObjectMapper mapper) throws IOException {
        Changelog.History history = histories.get(idx);
        Issue deepCopy = (Issue)((Object)mapper.readValue(mapper.writeValueAsString((Object)next), Issue.class));
        history.getItems().forEach(elm -> deepCopy.getCleanedVersionRepresentation().put(Optional.ofNullable(elm.getFieldId()).orElse(elm.getField()), elm.getFromString()));
        int nextIdx = idx + 1;
        if (nextIdx != histories.size()) {
            Changelog.History prevHistory = histories.get(nextIdx);
            deepCopy.getCleanedVersionRepresentation().put(CREATED_DATE, prevHistory.getCreated());
            deepCopy.getCleanedVersionRepresentation().put(VERSION_CHANGED_BY, prevHistory.getAuthor().getDisplayName());
            deepCopy.getCleanedVersionRepresentation().put(VERSION_CHANGED_BY_EMAIL, prevHistory.getAuthor().getEmailAddress());
        }
        return deepCopy;
    }

    private static String getValues(JsonNode node, String number) {
        JsonNode root = node.findPath(number);
        Function<ArrayNode, String> map = v -> {
            Iterable<JsonNode> iter = new ArrayNodeIterator((ArrayNode)v).iterable();
            return StreamSupport.stream(iter.spliterator(), false).map(ChangelogExtractor::extractValue).collect(Collectors.joining(","));
        };
        return ChangelogExtractor.tryExtractFromArrayNode(root, map).map(v -> v.length() > 1 ? v.substring(0, v.length() - 1) : v).orElse(ChangelogExtractor.extractValue(root));
    }

    private static Optional<String> tryExtractFromArrayNode(Object value, Function<ArrayNode, String> fn) {
        if (value instanceof ArrayNode) {
            return Optional.ofNullable(fn.apply((ArrayNode)value));
        }
        return Optional.empty();
    }

    private static class ArrayNodeIterator
    implements Iterator<JsonNode> {
        private ArrayNode source;
        int counter = 0;

        ArrayNodeIterator(ArrayNode source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            return this.counter <= this.source.size();
        }

        @Override
        public JsonNode next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            JsonNode jsonNode = this.source.get(this.counter);
            ++this.counter;
            return jsonNode;
        }

        Iterable<JsonNode> iterable() {
            return () -> this;
        }
    }
}

