/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jira.um.converters;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.jira.models.Issue;
import com.xebialabs.agatha.crawlers.jira.um.models.Ticket;
import com.xebialabs.agatha.crawlers.jira.um.models.TicketMapper;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueListConverter
implements UMConverter<List<Ticket>, Issue> {
    private static final Logger logger = LoggerFactory.getLogger(IssueListConverter.class);
    private final TicketMapper ticketMapper;
    private final ObjectMapper mapper;
    private final String TYPE;
    private final String VERSION;
    private final String PLUGIN_ID;
    private final String PLUGIN_VERSION;
    private final DataSourceTypeEnum dataSourceType = DataSourceTypeEnum.TICKET;

    public IssueListConverter(String PLUGIN_ID, String PLUGIN_VERSION, String TYPE, String VERSION, String storyPointsField, ObjectMapper mapper) {
        this.TYPE = TYPE;
        this.VERSION = VERSION;
        this.PLUGIN_ID = PLUGIN_ID;
        this.PLUGIN_VERSION = PLUGIN_VERSION;
        this.mapper = mapper;
        this.ticketMapper = new TicketMapper(storyPointsField);
    }

    public UMWrappedEntity<List<Ticket>> convert(Issue entity) throws CrawlerWorkException {
        try {
            List<Ticket> tickets = this.ticketMapper.extractTickets(entity, this.mapper);
            if (!tickets.isEmpty()) {
                return new UMWrappedEntity(this.PLUGIN_ID, this.PLUGIN_VERSION, this.TYPE, this.VERSION, tickets, this.dataSourceType).setId(tickets.get(0).getId()).setVersion(tickets.get(0).getVersion().toString()).wrap();
            }
            throw new CrawlerWorkException("No extracted tickets");
        }
        catch (IOException e) {
            logger.error("Cannot extract tickets", (Throwable)e);
            throw new CrawlerWorkException((Throwable)e);
        }
    }
}

