/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jira;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.crawlers.AbstractCrawler;
import com.xebialabs.agatha.crawlers.AbstractHttpCrawler;
import com.xebialabs.agatha.crawlers.CrawlerExecutor;
import com.xebialabs.agatha.crawlers.api.IngestionApi;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.jira.components.resolvers.JiraCrawlResolver;
import com.xebialabs.agatha.crawlers.jira.services.probe.ProbServiceImpl;
import com.xebialabs.agatha.crawlers.jira.services.probe.ProbeService;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobResult;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobWrapper;
import com.xebialabs.agatha.crawlers.shared.components.CrawlResolver;
import com.xebialabs.impact.api.ProbeResultMetadataVM;
import java.util.function.Function;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraCrawler
extends AbstractHttpCrawler {
    private static final Logger logger = LoggerFactory.getLogger(JiraCrawler.class);
    private final CrawlResolver<JiraCrawler> crawlResolver = new JiraCrawlResolver();

    public JiraCrawler() {
        super("JiraPlugin", AbstractHttpCrawler.AuthenticationTypes.AUTH_USERNAME_PASSWORD);
    }

    public JiraCrawler(Function<ObjectMapper, IngestionApi> ingestionApiProvider) {
        super("JiraPlugin", AbstractHttpCrawler.AuthenticationTypes.AUTH_USERNAME_PASSWORD, ingestionApiProvider);
    }

    protected CrawlerJobResult crawlItem(CrawlerJobWrapper crawlerJob) {
        try {
            return this.executeCrawl(crawlerJob);
        }
        catch (CrawlerWorkException e) {
            return CrawlerJobResult.fail((String)e.getMessage());
        }
    }

    protected ProbeResultMetadataVM probe(CrawlerJobWrapper crawlerJob) {
        return this.probeService().probeOnIssue();
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> logger.error(e.getMessage(), e));
        new CrawlerExecutor(JiraCrawler::new).execute();
    }

    private CrawlerJobResult executeCrawl(CrawlerJobWrapper crawlerJob) throws CrawlerWorkException {
        this.crawlResolver.resolve((AbstractCrawler)this, crawlerJob).execute();
        return CrawlerJobResult.success();
    }

    private ProbeService probeService() {
        return new ProbServiceImpl(this.endpoint, this.username, this.mapper, (OkHttpClient)this.getClient());
    }
}

