/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jira.services.crawl;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.jira.JiraCrawler;
import com.xebialabs.agatha.crawlers.jira.components.helpers.JiraResponseFetcher;
import com.xebialabs.agatha.crawlers.jira.messages.JiraCrawlMessage;
import com.xebialabs.agatha.crawlers.jira.models.dtos.Response;
import com.xebialabs.agatha.crawlers.shared.components.CrawlService;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.models.BaseEntity;
import com.xebialabs.impact.api.BaseCrawlerMessage;

public abstract class JiraBaseCrawl<M extends JiraCrawlMessage>
implements CrawlService {
    protected M message;
    protected JiraCrawler crawler;
    protected BaseCrawlerMessage dataMessage;
    protected final JiraResponseFetcher<JiraCrawler> responseFetcher;

    public JiraBaseCrawl(JiraCrawler crawler, M message, BaseCrawlerMessage dataMessage) {
        this.crawler = crawler;
        this.message = message;
        this.dataMessage = dataMessage;
        this.responseFetcher = new JiraResponseFetcher<JiraCrawler>(crawler);
    }

    protected <C extends JiraCrawlMessage> void startCrawlTask(Class<C> clazz) throws CrawlerWorkException {
        try {
            JiraCrawlMessage m = (JiraCrawlMessage)this.crawler.generateNewMessage(clazz, (BaseCrawlerMessage)this.message);
            m.setDataKey(clazz.getSimpleName());
            this.crawler.sendCrawlerTaskMessage(m);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    public static <T extends Response<? extends BaseEntity>> boolean isEmpty(CrawledDataWrappedResponse<T> response) {
        return response == null || response.getEntity() == null || ((Response)response.getEntity()).getValues() == null || ((Response)response.getEntity()).getValues().isEmpty();
    }
}

