/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jira.components.helpers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xebialabs.agatha.crawlers.AbstractHttpCrawler;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.jira.models.dtos.Response;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.components.ResponseFetcher;
import com.xebialabs.agatha.crawlers.shared.models.BaseEntity;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraResponseFetcher<C extends AbstractHttpCrawler>
extends ResponseFetcher<C> {
    private static final Logger logger = LoggerFactory.getLogger(JiraResponseFetcher.class);

    public JiraResponseFetcher(C crawler) {
        super(crawler);
    }

    public <E extends BaseEntity, R extends Response<E>> CrawledDataWrappedResponse<R> wrappedListResponse(URL url, TypeReference<List<E>> reference, Class<R> rClass) throws CrawlerWorkException {
        String content = null;
        try {
            content = this.responseAsContent(url);
            List values = (List)this.crawler.getMapper().readValue(content, reference);
            Response response = (Response)rClass.newInstance();
            response.setValues(values);
            return new CrawledDataWrappedResponse((Object)response, content);
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            logger.error("Error occurred in wrappedListResponse for Url - {}, with Response - {}", (Object)url, (Object)content);
            throw new CrawlerWorkException((Throwable)e);
        }
    }
}

