/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jenkinsv1.services;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.jenkinscommons.BaseJenkinsCrawler;
import com.xebialabs.agatha.crawlers.jenkinscommons.JenkinsURLHelper;
import com.xebialabs.agatha.crawlers.jenkinscommons.repository.BuildRepository;
import com.xebialabs.agatha.crawlers.jenkinscommons.transform.models.BuildUM;
import com.xebialabs.agatha.crawlers.jenkinsv1.JenkinsCrawler;
import com.xebialabs.agatha.crawlers.jenkinsv1.messages.JenkinsBuildJobMessage;
import com.xebialabs.agatha.crawlers.jenkinsv1.models.JenkinsBuild;
import com.xebialabs.agatha.crawlers.jenkinsv1.models.ParsedJenkinsBuild;
import com.xebialabs.agatha.crawlers.jenkinsv1.services.JenkinsBaseCrawl;
import com.xebialabs.agatha.crawlers.jenkinsv1.transform.converters.BuildConverter;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.repository.KeyValueRepository;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsBuildJobCrawl
extends JenkinsBaseCrawl<JenkinsBuildJobMessage, Void> {
    private static final Logger logger = LoggerFactory.getLogger(JenkinsBuildJobCrawl.class);
    private final UMConverter<BuildUM, ParsedJenkinsBuild> converter = new BuildConverter("JenkinsV1Plugin", "v1", "BUILD", "v1");
    private final KeyValueRepository<BuildUM> repository;

    public JenkinsBuildJobCrawl(JenkinsCrawler crawler, JenkinsBuildJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage);
        this.repository = new BuildRepository((BaseJenkinsCrawler)crawler, dataMessage);
    }

    protected CrawledDataWrappedResponse<Void> processMessage() throws CrawlerWorkException {
        logger.debug("Process JenkinsBuildJobMessage for endpoint {}", (Object)((JenkinsBuildJobMessage)this.message).getUrl());
        CrawledDataWrappedResponse response = this.responseFetcher.fetchContent(JenkinsURLHelper.apiUrl((String)((JenkinsBuildJobMessage)this.message).getUrl(), (String)"api/json"));
        try {
            this.handleResponse(response);
        }
        catch (IOException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
        return response;
    }

    private void handleResponse(CrawledDataWrappedResponse response) throws IOException, CrawlerWorkException {
        ParsedJenkinsBuild parsedJenkinsBuild = new ParsedJenkinsBuild(((JenkinsCrawler)this.crawler).getMapper(), response.getContent(), ((JenkinsBuildJobMessage)this.message).getBaseUrl());
        JenkinsBuild build = parsedJenkinsBuild.getParsedData();
        if (build.isBuilding()) {
            logger.debug("Ignoring the build [{}] since it is still building", (Object)build.getName());
        } else {
            this.enrichBuild(parsedJenkinsBuild);
            this.saveBuild(parsedJenkinsBuild);
        }
    }

    private void enrichBuild(ParsedJenkinsBuild parsedJenkinsBuild) throws CrawlerWorkException {
        JenkinsBuild build = parsedJenkinsBuild.getParsedData();
        parsedJenkinsBuild.setConsoleOutput(this.getConsoleOutput(build));
    }

    private void saveBuild(ParsedJenkinsBuild parsedJenkinsBuild) throws CrawlerWorkException {
        UMWrappedEntity umWrappedEntity = this.converter.convert((Object)parsedJenkinsBuild);
        this.repository.save(umWrappedEntity);
    }

    private Reader getConsoleOutput(JenkinsBuild build) throws CrawlerWorkException {
        logger.debug("Extracting console output for workflow build [{}]", (Object)build.getId());
        return this.responseFetcher.responseAsStream(JenkinsURLHelper.apiUrl((String)((JenkinsBuildJobMessage)this.message).getUrl(), (String)"consoleText"));
    }
}

