/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jenkinsv1.components;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.jenkinsv1.JenkinsCrawler;
import com.xebialabs.agatha.crawlers.jenkinsv1.messages.JenkinsBuildFlowJobMessage;
import com.xebialabs.agatha.crawlers.jenkinsv1.messages.JenkinsBuildJobMessage;
import com.xebialabs.agatha.crawlers.jenkinsv1.messages.JenkinsFolderJobMessage;
import com.xebialabs.agatha.crawlers.jenkinsv1.services.JenkinsBuildFlowJobCrawl;
import com.xebialabs.agatha.crawlers.jenkinsv1.services.JenkinsBuildJobCrawl;
import com.xebialabs.agatha.crawlers.jenkinsv1.services.JenkinsFolderJobCrawl;
import com.xebialabs.agatha.crawlers.shared.components.BaseCrawlFactory;
import com.xebialabs.agatha.crawlers.shared.components.CrawlService;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.io.IOException;

public class JenkinsCrawlFactory
extends BaseCrawlFactory<JenkinsCrawler> {
    private CrawlService buildJobCrawl(JenkinsCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new JenkinsBuildJobCrawl(crawler, (JenkinsBuildJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, JenkinsBuildJobMessage.class)), crawlerDataMessage);
    }

    private CrawlService buildFlowJobCrawl(JenkinsCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new JenkinsBuildFlowJobCrawl(crawler, (JenkinsBuildFlowJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, JenkinsBuildFlowJobMessage.class)), crawlerDataMessage);
    }

    private CrawlService folderJobCrawl(JenkinsCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new JenkinsFolderJobCrawl(crawler, (JenkinsFolderJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, JenkinsFolderJobMessage.class)), crawlerDataMessage);
    }

    public CrawlService getInstance(JenkinsCrawler crawler, BaseCrawlerMessage message) throws CrawlerWorkException {
        CrawlService jenkinsCrawl;
        try {
            switch (message.getDataKey().toLowerCase()) {
                case "jenkinsfolderjobmessage": {
                    jenkinsCrawl = this.folderJobCrawl(crawler, message);
                    break;
                }
                case "jenkinsbuildflowjobmessage": {
                    jenkinsCrawl = this.buildFlowJobCrawl(crawler, message);
                    break;
                }
                case "jenkinsbuildjobmessage": {
                    jenkinsCrawl = this.buildJobCrawl(crawler, message);
                    break;
                }
                default: {
                    throw new CrawlerWorkException("No Crawler implementation found.");
                }
            }
        }
        catch (IOException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
        return jenkinsCrawl;
    }
}

