/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jenkinsv1.transform.converters;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.jenkinscommons.JenkinsURLHelper;
import com.xebialabs.agatha.crawlers.jenkinscommons.transform.models.BuildUM;
import com.xebialabs.agatha.crawlers.jenkinsv1.models.JenkinsBuild;
import com.xebialabs.agatha.crawlers.jenkinsv1.models.ParsedJenkinsBuild;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class BuildConverter
implements UMConverter<BuildUM, ParsedJenkinsBuild> {
    private final String pluginId;
    private final String pluginVersion;
    private final String type;
    private final String typeVersion;

    public BuildConverter(String pluginId, String pluginVersion, String type, String typeVersion) {
        this.pluginId = pluginId;
        this.pluginVersion = pluginVersion;
        this.type = type;
        this.typeVersion = typeVersion;
    }

    public UMWrappedEntity<BuildUM> convert(ParsedJenkinsBuild entity) throws CrawlerWorkException {
        BuildUM build = new BuildUM();
        this.populateTopLevelFields(build, entity);
        this.populateOther(build, entity);
        this.populateURLParts(build, entity);
        return this.wrappedEntity(entity, build);
    }

    private void populateURLParts(BuildUM build, ParsedJenkinsBuild entity) throws CrawlerWorkException {
        JenkinsBuild jenkinsBuild = entity.getParsedData();
        HashMap<String, String> urlParts = new HashMap<String, String>();
        urlParts.put("path", this.extractJobPath(jenkinsBuild.getUrl(), jenkinsBuild.getBaseUrl()));
        build.setUrlParts(urlParts);
    }

    private String extractJobPath(String url, String baseUrl) throws CrawlerWorkException {
        return JenkinsURLHelper.jobUrl((String)url, (String)baseUrl).replaceAll(baseUrl, "");
    }

    private UMWrappedEntity<BuildUM> wrappedEntity(ParsedJenkinsBuild entity, BuildUM um) {
        return new UMWrappedEntity(this.pluginId, this.pluginVersion, this.type, this.typeVersion, (Object)um, DataSourceTypeEnum.BUILD).setId(um.getId()).setVersion("0").wrap();
    }

    public static String artifactId(String id, long timestamp) {
        return String.format("%s-%s", id, timestamp);
    }

    private void populateOther(BuildUM build, ParsedJenkinsBuild entity) {
        BuildUM.Other other = new BuildUM.Other();
        build.setOther(other);
        this.populateRaw(build, entity);
        this.populateRelations(build, entity);
    }

    private void populateRaw(BuildUM build, ParsedJenkinsBuild entity) {
        BuildUM.Other other = build.getOther();
        HashMap<String, Object> raw = new HashMap<String, Object>();
        raw.put("consoleOutput", entity.getConsoleOutput());
        raw.put("buildData", entity.getRawData());
        other.setRaw(raw);
    }

    private void populateRelations(BuildUM build, ParsedJenkinsBuild entity) {
        Map relation = Optional.ofNullable(entity.getRawData()).map(m -> m.get("actions")).filter(m -> m instanceof List).map(c -> ((List)c).stream().filter(l -> l instanceof Map).map(o -> (Map)o).map(m -> m.get("causes")).filter(Objects::nonNull).filter(o -> o instanceof List).flatMap(o -> ((List)o).stream()).map(o -> (Map)o).filter(m -> m.get("upstreamBuild") != null || m.get("upstreamProject") != null).findAny().map(this::upstreamRelations).orElse(null)).orElse(null);
        build.getOther().setRelations(relation);
    }

    private Map<String, String> upstreamRelations(Map<Object, Object> map) {
        HashMap<String, String> relation = new HashMap<String, String>();
        String jobId = map.get("upstreamProject") != null ? map.get("upstreamProject").toString() : "";
        String buildId = String.format("%s/%s", jobId, map.get("upstreamBuild") != null ? map.get("upstreamBuild").toString() : "");
        if (!jobId.isEmpty()) {
            relation.put("jobId", jobId);
        }
        if (!buildId.isEmpty()) {
            relation.put("buildId", buildId);
        }
        return relation.isEmpty() ? null : relation;
    }

    private void populateTopLevelFields(BuildUM build, ParsedJenkinsBuild entity) {
        JenkinsBuild jenkinsBuild = entity.getParsedData();
        build.setId(BuildConverter.artifactId(jenkinsBuild.getId(), jenkinsBuild.getTimestamp()));
        build.setTitle(jenkinsBuild.getName());
        build.setStartMs(Long.valueOf(jenkinsBuild.getTimestamp()));
        build.setFinishMs(Long.valueOf(jenkinsBuild.getTimestamp() + Long.parseLong(entity.getRawData().get("duration") + "")));
        build.setStatus(this.getBuildStatus((String)entity.getRawData().get("result")));
    }

    private String getBuildStatus(String buildStatus) {
        switch (buildStatus) {
            case "SUCCESS": {
                return "SUCCEEDED";
            }
            case "UNSTABLE": {
                return "SUCCEEDED";
            }
            case "FAILURE": {
                return "FAILED";
            }
            case "NOT_BUILT": {
                return "PLANNED";
            }
            case "ABORTED": {
                return "FAILED";
            }
        }
        return "UNKNOWN";
    }
}

