/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import io.grpc.ConnectivityState;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class ConnectivityStateManager {
    private ArrayList<StateCallbackEntry> callbacks;
    private ConnectivityState state;

    ConnectivityStateManager(ConnectivityState initialState) {
        this.state = initialState;
    }

    void notifyWhenStateChanged(Runnable callback, Executor executor, ConnectivityState source) {
        StateCallbackEntry callbackEntry = new StateCallbackEntry(callback, executor);
        if (this.state != source) {
            callbackEntry.runInExecutor();
        } else {
            if (this.callbacks == null) {
                this.callbacks = new ArrayList();
            }
            this.callbacks.add(callbackEntry);
        }
    }

    void gotoState(ConnectivityState newState) {
        if (this.state != newState) {
            if (this.state == ConnectivityState.SHUTDOWN) {
                throw new IllegalStateException("Cannot transition out of SHUTDOWN to " + (Object)((Object)newState));
            }
            this.state = newState;
            if (this.callbacks == null) {
                return;
            }
            ArrayList<StateCallbackEntry> savedCallbacks = this.callbacks;
            this.callbacks = null;
            for (StateCallbackEntry callback : savedCallbacks) {
                callback.runInExecutor();
            }
        }
    }

    ConnectivityState getState() {
        return this.state;
    }

    private static class StateCallbackEntry {
        final Runnable callback;
        final Executor executor;

        StateCallbackEntry(Runnable callback, Executor executor) {
            this.callback = callback;
            this.executor = executor;
        }

        void runInExecutor() {
            this.executor.execute(this.callback);
        }
    }
}

