/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.ws;

import akka.NotUsed;
import akka.annotation.InternalApi;
import akka.http.impl.engine.ws.FrameData;
import akka.http.impl.engine.ws.FrameError;
import akka.http.impl.engine.ws.FrameEvent;
import akka.http.impl.engine.ws.FrameEventOrError;
import akka.http.impl.engine.ws.FrameEventParser$;
import akka.http.impl.engine.ws.FrameHeader;
import akka.http.impl.engine.ws.FrameStart;
import akka.http.impl.engine.ws.Masking$;
import akka.http.impl.engine.ws.Masking$Masker$;
import akka.http.impl.engine.ws.Protocol;
import akka.http.impl.engine.ws.ProtocolException;
import akka.stream.Attributes;
import akka.stream.FlowShape;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.scaladsl.BidiFlow;
import akka.stream.scaladsl.Flow;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.util.ByteString;
import java.util.Random;
import scala.Function0;
import scala.MatchError;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=uAB\u0001\u0003\u0011\u0003AA\"A\u0004NCN\\\u0017N\\4\u000b\u0005\r!\u0011AA<t\u0015\t)a!\u0001\u0004f]\u001eLg.\u001a\u0006\u0003\u000f!\tA![7qY*\u0011\u0011BC\u0001\u0005QR$\bOC\u0001\f\u0003\u0011\t7n[1\u0011\u00055qQ\"\u0001\u0002\u0007\r=\u0011\u0001\u0012\u0001\u0005\u0011\u0005\u001di\u0015m]6j]\u001e\u001c\"AD\t\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g\u0011\u0015Ab\u0002\"\u0001\u001b\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u0007\t\u000bqqA\u0011A\u000f\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007y\u0001T\u0007E\u0004 I\u0019JcE\n\u0017\u000e\u0003\u0001R!!\t\u0012\u0002\u0011M\u001c\u0017\r\\1eg2T!a\t\u0006\u0002\rM$(/Z1n\u0013\t)\u0003E\u0001\u0005CS\u0012Lg\t\\8x!\tiq%\u0003\u0002)\u0005\tQaI]1nK\u00163XM\u001c;\u0011\u00055Q\u0013BA\u0016\u0003\u0005E1%/Y7f\u000bZ,g\u000e^(s\u000bJ\u0014xN\u001d\t\u0003[9j\u0011AC\u0005\u0003_)\u0011qAT8u+N,G\rC\u000327\u0001\u0007!'\u0001\u0006tKJ4XM]*jI\u0016\u0004\"AE\u001a\n\u0005Q\u001a\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006mm\u0001\raN\u0001\u000b[\u0006\u001c8NU1oI>l\u0007c\u0001\n9u%\u0011\u0011h\u0005\u0002\n\rVt7\r^5p]B\u0002\"a\u000f!\u000e\u0003qR!!\u0010 \u0002\tU$\u0018\u000e\u001c\u0006\u0002\u007f\u0005!!.\u0019<b\u0013\t\tEH\u0001\u0004SC:$w.\u001c\u0005\u0006\u0007:!\t\u0001R\u0001\u0007[\u0006\u001c8.\u00134\u0015\u0007\u0015C%\nE\u0003 \r\u001a2C&\u0003\u0002HA\t!a\t\\8x\u0011\u0015I%\t1\u00013\u0003%\u0019wN\u001c3ji&|g\u000eC\u00037\u0005\u0002\u0007q\u0007C\u0003M\u001d\u0011\u0005Q*\u0001\u0005v]6\f7o[%g)\tqu\nE\u0003 \r\u001aJC\u0006C\u0003J\u0017\u0002\u0007!G\u0002\u0003\u0010\u001d\u0019\t6C\u0001)S!\t\u0019F+D\u0001\u000f\r\u0015)f\"!\u0003W\u0005\u0019i\u0015m]6feN\u0011Ak\u0016\t\u00041nkV\"A-\u000b\u0005i\u0013\u0013!B:uC\u001e,\u0017B\u0001/Z\u0005)9%/\u00199i'R\fw-\u001a\t\u0005=~3\u0013&D\u0001#\u0013\t\u0001'EA\u0005GY><8\u000b[1qK\")\u0001\u0004\u0016C\u0001ER\t!\u000bC\u0003e)\u001a\u0005Q-A\u0006fqR\u0014\u0018m\u0019;NCN\\GC\u00014j!\t\u0011r-\u0003\u0002i'\t\u0019\u0011J\u001c;\t\u000b)\u001c\u0007\u0019A6\u0002\r!,\u0017\rZ3s!\tiA.\u0003\u0002n\u0005\tYaI]1nK\"+\u0017\rZ3s\u0011\u0015yGK\"\u0001q\u0003)\u0019X\r\u001e(fo6\u000b7o\u001b\u000b\u0004WF\u0014\b\"\u00026o\u0001\u0004Y\u0007\"B:o\u0001\u00041\u0017\u0001B7bg.Dq!\u001e+C\u0002\u0013\u0005a/\u0001\u0002j]V\tq\u000fE\u0002_q\u001aJ!!\u001f\u0012\u0003\u000b%sG.\u001a;\t\rm$\u0006\u0015!\u0003x\u0003\rIg\u000e\t\u0005\b{R\u0013\r\u0011\"\u0001\u007f\u0003\ryW\u000f^\u000b\u0002\u007fB!a,!\u0001*\u0013\r\t\u0019A\t\u0002\u0007\u001fV$H.\u001a;\t\u000f\u0005\u001dA\u000b)A\u0005\u007f\u0006!q.\u001e;!\u0011%\tY\u0001\u0016b\u0001\n\u0003\ni!A\u0003tQ\u0006\u0004X-F\u0001^\u0011\u001d\t\t\u0002\u0016Q\u0001\nu\u000baa\u001d5ba\u0016\u0004\u0003bBA\u000b)\u0012\u0005\u0013qC\u0001\fGJ,\u0017\r^3M_\u001eL7\r\u0006\u0003\u0002\u001a\u0005}\u0001c\u0001-\u0002\u001c%\u0019\u0011QD-\u0003\u001f\u001d\u0013\u0018\r\u001d5Ti\u0006<W\rT8hS\u000eD\u0001\"!\t\u0002\u0014\u0001\u0007\u00111E\u0001\u0014S:DWM]5uK\u0012\fE\u000f\u001e:jEV$Xm\u001d\t\u0004=\u0006\u0015\u0012bAA\u0014E\tQ\u0011\t\u001e;sS\n,H/Z:\t\u0013\u0005-\u0002K!A!\u0002\u0013Q\u0014A\u0002:b]\u0012|W\u000e\u0003\u0004\u0019!\u0012\u0005\u0011q\u0006\u000b\u0005\u0003c\t\u0019\u0004\u0005\u0002T!\"9\u00111FA\u0017\u0001\u0004Q\u0004B\u00023Q\t\u0003\t9\u0004F\u0002g\u0003sAaA[A\u001b\u0001\u0004Y\u0007BB8Q\t\u0003\ti\u0004F\u0003l\u0003\u007f\t\t\u0005\u0003\u0004k\u0003w\u0001\ra\u001b\u0005\u0007g\u0006m\u0002\u0019\u00014\t\u000f\u0005\u0015\u0003\u000b\"\u0011\u0002H\u0005AAo\\*ue&tw\r\u0006\u0002\u0002JA!\u00111JA-\u001d\u0011\ti%!\u0016\u0011\u0007\u0005=3#\u0004\u0002\u0002R)\u0019\u00111K\r\u0002\rq\u0012xn\u001c;?\u0013\r\t9fE\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0013Q\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]3cB\u0004\u0002b9AI!a\u0019\u0002\u0013UsW.Y:lS:<\u0007cA*\u0002f\u00199\u0011q\r\b\t\n\u0005%$!C+o[\u0006\u001c8.\u001b8h'\r\t)G\u0015\u0005\b1\u0005\u0015D\u0011AA7)\t\t\u0019\u0007C\u0004e\u0003K\"\t!!\u001d\u0015\u0007\u0019\f\u0019\b\u0003\u0004k\u0003_\u0002\ra\u001b\u0005\b_\u0006\u0015D\u0011AA<)\u0015Y\u0017\u0011PA>\u0011\u0019Q\u0017Q\u000fa\u0001W\"11/!\u001eA\u0002\u0019D\u0001\"!\u0012\u0002f\u0011\u0005\u0013q\t\u0015\u0004\u001d\u0005\u0005\u0005\u0003BAB\u0003\u0013k!!!\"\u000b\u0007\u0005\u001d%\"\u0001\u0006b]:|G/\u0019;j_:LA!a#\u0002\u0006\nY\u0011J\u001c;fe:\fG.\u00119jQ\r\u0001\u0011\u0011\u0011")
@InternalApi
public final class Masking {
    public static Flow<FrameEvent, FrameEventOrError, NotUsed> unmaskIf(boolean bl) {
        return Masking$.MODULE$.unmaskIf(bl);
    }

    public static Flow<FrameEvent, FrameEvent, NotUsed> maskIf(boolean bl, Function0<Random> function0) {
        return Masking$.MODULE$.maskIf(bl, function0);
    }

    public static BidiFlow<FrameEvent, FrameEventOrError, FrameEvent, FrameEvent, NotUsed> apply(boolean bl, Function0<Random> function0) {
        return Masking$.MODULE$.apply(bl, function0);
    }

    public static abstract class Masker
    extends GraphStage<FlowShape<FrameEvent, FrameEventOrError>> {
        private final Inlet<FrameEvent> in = Inlet$.MODULE$.apply(new StringBuilder(3).append(this.toString()).append("-in").toString());
        private final Outlet<FrameEventOrError> out = Outlet$.MODULE$.apply(new StringBuilder(4).append(this.toString()).append("-out").toString());
        private final FlowShape<FrameEvent, FrameEventOrError> shape = new FlowShape<FrameEvent, FrameEventOrError>(this.in(), this.out());

        public abstract int extractMask(FrameHeader var1);

        public abstract FrameHeader setNewMask(FrameHeader var1, int var2);

        public Inlet<FrameEvent> in() {
            return this.in;
        }

        public Outlet<FrameEventOrError> out() {
            return this.out;
        }

        @Override
        public FlowShape<FrameEvent, FrameEventOrError> shape() {
            return this.shape;
        }

        @Override
        public GraphStageLogic createLogic(Attributes inheritedAttributes) {
            return new OutHandler(this){
                private final /* synthetic */ Masker $outer;

                public void onUpstreamFinish() throws Exception {
                    InHandler.onUpstreamFinish$(this);
                }

                public void onUpstreamFailure(Throwable ex) throws Exception {
                    InHandler.onUpstreamFailure$(this, ex);
                }

                public void onDownstreamFinish() throws Exception {
                    OutHandler.onDownstreamFinish$(this);
                }

                public void onPush() {
                    FrameEvent frameEvent = this.grab(this.$outer.in());
                    if (frameEvent instanceof FrameStart) {
                        BoxedUnit boxedUnit;
                        FrameStart frameStart = (FrameStart)frameEvent;
                        FrameHeader header = frameStart.header();
                        ByteString data = frameStart.data();
                        try {
                            int mask = this.$outer.extractMask(header);
                            Tuple2<ByteString, Object> tuple2 = FrameEventParser$.MODULE$.mask(data, mask);
                            if (tuple2 == null) {
                                throw new MatchError(tuple2);
                            }
                            ByteString masked = tuple2._1();
                            int newMask = tuple2._2$mcI$sp();
                            Tuple2<ByteString, Integer> tuple22 = new Tuple2<ByteString, Integer>(masked, BoxesRunTime.boxToInteger(newMask));
                            Tuple2<ByteString, Integer> tuple23 = tuple22;
                            ByteString masked2 = tuple23._1();
                            int newMask2 = tuple23._2$mcI$sp();
                            if (!frameStart.lastPart()) {
                                this.setHandler(this.$outer.in(), this.runningHandler(newMask2, this));
                            }
                            this.push(this.$outer.out(), frameStart.copy(this.$outer.setNewMask(header, mask), masked2));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        catch (ProtocolException p) {
                            this.setHandler(this.$outer.in(), this.doneHandler());
                            this.push(this.$outer.out(), new FrameError(p));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else if (frameEvent instanceof FrameData) {
                        this.fail(this.$outer.out(), new IllegalStateException("unexpected FrameData (need FrameStart first)"));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError(frameEvent);
                    }
                }

                private InHandler doneHandler() {
                    return new InHandler(this){
                        private final /* synthetic */ Masker$$anon$1 $outer;

                        public void onUpstreamFinish() throws Exception {
                            InHandler.onUpstreamFinish$(this);
                        }

                        public void onUpstreamFailure(Throwable ex) throws Exception {
                            InHandler.onUpstreamFailure$(this, ex);
                        }

                        public void onPush() {
                            this.$outer.pull(this.$outer.akka$http$impl$engine$ws$Masking$Masker$$anon$$$outer().in());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            InHandler.$init$(this);
                        }
                    };
                }

                private InHandler runningHandler(int initialMask, InHandler nextState) {
                    return new InHandler(this, initialMask, nextState){
                        private int mask;
                        private final /* synthetic */ Masker$$anon$1 $outer;
                        private final InHandler nextState$1;

                        public void onUpstreamFinish() throws Exception {
                            InHandler.onUpstreamFinish$(this);
                        }

                        public void onUpstreamFailure(Throwable ex) throws Exception {
                            InHandler.onUpstreamFailure$(this, ex);
                        }

                        private int mask() {
                            return this.mask;
                        }

                        private void mask_$eq(int x$1) {
                            this.mask = x$1;
                        }

                        public void onPush() {
                            Tuple2<ByteString, Object> tuple2;
                            FrameEvent part = this.$outer.grab(this.$outer.akka$http$impl$engine$ws$Masking$Masker$$anon$$$outer().in());
                            if (part.lastPart()) {
                                this.$outer.setHandler(this.$outer.akka$http$impl$engine$ws$Masking$Masker$$anon$$$outer().in(), this.nextState$1);
                            }
                            if ((tuple2 = FrameEventParser$.MODULE$.mask(part.data(), this.mask())) == null) {
                                throw new MatchError(tuple2);
                            }
                            ByteString masked = tuple2._1();
                            int newMask = tuple2._2$mcI$sp();
                            Tuple2<ByteString, Integer> tuple22 = new Tuple2<ByteString, Integer>(masked, BoxesRunTime.boxToInteger(newMask));
                            Tuple2<ByteString, Integer> tuple23 = tuple22;
                            ByteString masked2 = tuple23._1();
                            int newMask2 = tuple23._2$mcI$sp();
                            this.mask_$eq(newMask2);
                            this.$outer.push(this.$outer.akka$http$impl$engine$ws$Masking$Masker$$anon$$$outer().out(), part.withData(masked2));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.nextState$1 = nextState$1;
                            InHandler.$init$(this);
                            this.mask = initialMask$1;
                        }
                    };
                }

                public void onPull() {
                    this.pull(this.$outer.in());
                }

                public /* synthetic */ Masker akka$http$impl$engine$ws$Masking$Masker$$anon$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    OutHandler.$init$(this);
                    InHandler.$init$(this);
                    this.setHandler($outer.in(), this);
                    this.setHandler($outer.out(), this);
                }
            };
        }
    }

    public static final class Masking
    extends Masker {
        private final Random random;

        @Override
        public int extractMask(FrameHeader header) {
            return this.random.nextInt();
        }

        @Override
        public FrameHeader setNewMask(FrameHeader header, int mask) {
            if (header.mask().isDefined()) {
                throw new ProtocolException("Frame mustn't already be masked");
            }
            Some<Object> x$3 = new Some<Object>(BoxesRunTime.boxToInteger(mask));
            Protocol.Opcode x$4 = header.copy$default$1();
            long x$5 = header.copy$default$3();
            boolean x$6 = header.copy$default$4();
            boolean x$7 = header.copy$default$5();
            boolean x$8 = header.copy$default$6();
            boolean x$9 = header.copy$default$7();
            return header.copy(x$4, x$3, x$5, x$6, x$7, x$8, x$9);
        }

        public String toString() {
            return new StringBuilder(9).append("Masking(").append(this.random).append(")").toString();
        }

        public Masking(Random random) {
            this.random = random;
        }
    }
}

