/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jenkinscommons;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import okhttp3.HttpUrl;

public final class JenkinsURLHelper {
    public static final String API_FOLDER_SUFFIX = "api/json?tree=name,jobs[name,url]";
    public static final String API_BUILD_FLOW_SUFFIX = "api/json?tree=*,builds[name,url,timestamp,number]";
    public static final String API_DATA_SUFFIX = "api/json";
    public static final String API_CONSOLE_OUTPUT_SUFFIX = "consoleText";

    private JenkinsURLHelper() {
    }

    public static URL apiUrl(String baseUrl, String apiSuffix) throws CrawlerWorkException {
        try {
            return new URL(new URL(baseUrl), apiSuffix);
        }
        catch (MalformedURLException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    public static String jobUrl(String url, String baseUrl) throws CrawlerWorkException {
        try {
            URL serverUrl = new URL(baseUrl);
            URL jobUrl = new URL(url);
            HttpUrl.Builder builder = new HttpUrl.Builder().scheme(serverUrl.getProtocol()).host(serverUrl.getHost());
            if (-1 != serverUrl.getPort()) {
                builder.port(serverUrl.getPort());
            }
            return URLDecoder.decode(builder.build().url().toString() + jobUrl.getPath().substring(1), "UTF-8");
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }
}

