/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf.builtin.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;
import com.hubspot.jackson.datatype.protobuf.ExtensionRegistryWrapper;
import com.hubspot.jackson.datatype.protobuf.PropertyNamingStrategyWrapper;
import com.hubspot.jackson.datatype.protobuf.ProtobufDeserializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageDeserializer<T extends Message, V extends Message.Builder>
extends ProtobufDeserializer<T, V> {
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final ExtensionRegistryWrapper extensionRegistry;

    public MessageDeserializer(Class<T> messageType, ExtensionRegistryWrapper extensionRegistry) {
        super(messageType);
        this.extensionRegistry = extensionRegistry;
    }

    @Override
    protected void populate(V builder, JsonParser parser, DeserializationContext context) throws IOException {
        JsonToken token = parser.getCurrentToken();
        if (token == JsonToken.START_ARRAY) {
            token = parser.nextToken();
        }
        switch (token) {
            case END_OBJECT: {
                return;
            }
            case START_OBJECT: {
                token = parser.nextToken();
                if (token != JsonToken.END_OBJECT) break;
                return;
            }
        }
        Descriptors.Descriptor descriptor = builder.getDescriptorForType();
        Map<String, Descriptors.FieldDescriptor> fieldLookup = this.buildFieldLookup(descriptor, context);
        Map<Object, Object> extensionLookup = builder instanceof GeneratedMessageV3.ExtendableMessageOrBuilder ? this.buildExtensionLookup(descriptor, context) : Collections.emptyMap();
        do {
            ExtensionRegistry.ExtensionInfo extensionInfo;
            if (!token.equals((Object)JsonToken.FIELD_NAME)) {
                throw this.reportWrongToken(parser, JsonToken.FIELD_NAME, context, "");
            }
            String name = parser.getCurrentName();
            Descriptors.FieldDescriptor field = fieldLookup.get(name);
            Message defaultInstance = null;
            if (field == null && (extensionInfo = (ExtensionRegistry.ExtensionInfo)extensionLookup.get(name)) != null) {
                field = extensionInfo.descriptor;
                defaultInstance = extensionInfo.defaultInstance;
            }
            if (field == null) {
                if (!context.handleUnknownProperty(parser, (JsonDeserializer)this, builder, name)) {
                    context.reportUnknownProperty(builder, name, (JsonDeserializer)this);
                }
                context.handleUnknownProperty(parser, (JsonDeserializer)this, builder, name);
                parser.nextToken();
                parser.skipChildren();
                continue;
            }
            parser.nextToken();
            this.setField(builder, field, defaultInstance, parser, context);
        } while ((token = parser.nextToken()) != JsonToken.END_OBJECT);
    }

    private Map<String, Descriptors.FieldDescriptor> buildFieldLookup(Descriptors.Descriptor descriptor, DeserializationContext context) {
        PropertyNamingStrategyWrapper namingStrategy = new PropertyNamingStrategyWrapper(context.getConfig().getPropertyNamingStrategy());
        HashMap<String, Descriptors.FieldDescriptor> fieldLookup = new HashMap<String, Descriptors.FieldDescriptor>();
        for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
            fieldLookup.put(namingStrategy.translate(field.getName()), field);
        }
        return fieldLookup;
    }

    private Map<String, ExtensionRegistry.ExtensionInfo> buildExtensionLookup(Descriptors.Descriptor descriptor, DeserializationContext context) {
        PropertyNamingStrategyWrapper namingStrategy = new PropertyNamingStrategyWrapper(context.getConfig().getPropertyNamingStrategy());
        HashMap<String, ExtensionRegistry.ExtensionInfo> extensionLookup = new HashMap<String, ExtensionRegistry.ExtensionInfo>();
        for (ExtensionRegistry.ExtensionInfo extensionInfo : this.extensionRegistry.getExtensionsByDescriptor(descriptor)) {
            extensionLookup.put(namingStrategy.translate(extensionInfo.descriptor.getName()), extensionInfo);
        }
        return extensionLookup;
    }

    private void setField(V builder, Descriptors.FieldDescriptor field, Message defaultInstance, JsonParser parser, DeserializationContext context) throws IOException {
        if (field.isMapField()) {
            List<Message> entries = this.readMap((Message.Builder)builder, field, parser, context);
            for (Message entry : entries) {
                builder.addRepeatedField(field, (Object)entry);
            }
        } else if (field.isRepeated()) {
            List<Object> values = this.readArray((Message.Builder)builder, field, defaultInstance, parser, context);
            for (Object value : values) {
                builder.addRepeatedField(field, value);
            }
        } else {
            Object value = this.readValue((Message.Builder)builder, field, defaultInstance, parser, context);
            if (value != null) {
                builder.setField(field, value);
            }
        }
    }

    private AssertionError reportWrongToken(JsonParser parser, JsonToken expected, DeserializationContext context, String message) throws JsonMappingException {
        throw context.wrongTokenException(parser, expected, message);
    }
}

