/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.github.transform.converters;

import com.xebialabs.agatha.crawlers.github.GithubUtil;
import com.xebialabs.agatha.crawlers.github.models.Commit;
import com.xebialabs.agatha.crawlers.github.models.Tag;
import com.xebialabs.agatha.crawlers.github.transform.models.LabelUM;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.util.HashMap;

public class SimpleTagConverter
implements UMConverter<LabelUM, Commit> {
    public static final String REFS_TAGS_PREFIX = "refs/tags/";
    private final String pluginId;
    private final String pluginVersion;
    private final String type;
    private final String typeVersion;
    private String organization;
    private String repo;
    private String id;

    public SimpleTagConverter(String pluginId, String pluginVersion, String type, String typeVersion) {
        this.pluginId = pluginId;
        this.pluginVersion = pluginVersion;
        this.type = type;
        this.typeVersion = typeVersion;
    }

    public String getOrganization() {
        return this.organization;
    }

    public SimpleTagConverter setOrganization(String organization) {
        this.organization = organization;
        return this;
    }

    public String getRepo() {
        return this.repo;
    }

    public SimpleTagConverter setRepo(String repo) {
        this.repo = repo;
        return this;
    }

    public UMWrappedEntity<LabelUM> convert(Commit commit) {
        LabelUM um = new LabelUM();
        this.populateTopLevelFields(commit, um);
        this.populateUrlParts(commit, um);
        this.populateOther(commit, um);
        this.populateAdditionalFields(um);
        return this.wrappedEntity(um, commit.getSha());
    }

    private void populateTopLevelFields(Commit commit, LabelUM um) {
        um.setId(this.generateId(this.id));
        um.setStartMs(commit.getCommit().getAuthor().getTimeStamp().toInstant().toEpochMilli());
        um.setTitle(this.id);
    }

    private void populateOther(Commit commit, LabelUM um) {
        LabelUM.Other other = new LabelUM.Other();
        other.setRaw((Object)commit);
        this.populateRelations(commit, other);
        um.setOther(other);
    }

    private void populateRelations(Commit commit, LabelUM.Other other) {
        HashMap<String, String> to = new HashMap<String, String>();
        to.put("to", this.generateId(commit.getSha()));
        HashMap<String, Object> relations = new HashMap<String, Object>();
        relations.put("commit", to);
        other.setRelations(relations);
    }

    private void populateUrlParts(Commit tag, LabelUM um) {
        HashMap<String, String> urlParts = new HashMap<String, String>();
        urlParts.put("repository", GithubUtil.generateDataId(this.organization, this.repo));
        urlParts.put("organization", this.organization);
        urlParts.put("repo", this.repo);
        urlParts.put("title", this.id);
        um.setUrlParts(urlParts);
    }

    private void populateAdditionalFields(LabelUM um) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("organization", this.organization);
        fields.put("repo", this.repo);
        um.setAdditionalFields(fields);
    }

    public String generateId(String id) {
        return GithubUtil.generateDataId(this.organization, this.repo, id);
    }

    private UMWrappedEntity<LabelUM> wrappedEntity(LabelUM um, String commitSha) {
        return new UMWrappedEntity(this.pluginId, this.pluginVersion, this.type, this.typeVersion, (Object)um, DataSourceTypeEnum.LABEL).setId(um.getId()).setVersion(commitSha).wrap();
    }

    public String getId() {
        return this.id;
    }

    public SimpleTagConverter setId(String id) {
        this.id = id;
        return this;
    }

    public String getSimpleTagId(Tag tag) {
        return tag.getRef().substring(REFS_TAGS_PREFIX.length());
    }
}

