/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.github.services;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.github.GithubCrawler;
import com.xebialabs.agatha.crawlers.github.components.GithubResponseFetcher;
import com.xebialabs.agatha.crawlers.github.messages.GithubSimpleTagJobMessage;
import com.xebialabs.agatha.crawlers.github.models.Commit;
import com.xebialabs.agatha.crawlers.github.repository.LabelRepository;
import com.xebialabs.agatha.crawlers.github.services.GithubBaseCrawl;
import com.xebialabs.agatha.crawlers.github.transform.converters.SimpleTagConverter;
import com.xebialabs.agatha.crawlers.github.transform.models.LabelUM;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.repository.KeyValueRepository;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GithubSimpleTagCrawl
extends GithubBaseCrawl<GithubSimpleTagJobMessage, Commit> {
    private static final Logger logger = LoggerFactory.getLogger(GithubSimpleTagCrawl.class);
    private final UMConverter<LabelUM, Commit> converter;
    private final KeyValueRepository<LabelUM> repository;

    public GithubSimpleTagCrawl(GithubCrawler crawler, GithubSimpleTagJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage, new GithubResponseFetcher(crawler));
        this.converter = new SimpleTagConverter("GithubPlugin", "v1", "LABEL", "v1").setOrganization(message.getOrgName()).setRepo(message.getRepoName()).setId(message.getId());
        this.repository = new LabelRepository(crawler, dataMessage);
    }

    @Override
    protected CrawledDataWrappedResponse<Commit> processGithubMessage() throws CrawlerWorkException {
        logger.debug("Process GithubSimpleTagJobMessage for endpoint {} - commit - {}, org {}, repo - {}", new Object[]{((GithubSimpleTagJobMessage)this.message).getBaseUrl(), ((GithubSimpleTagJobMessage)this.message).getId(), ((GithubSimpleTagJobMessage)this.message).getOrgName(), ((GithubSimpleTagJobMessage)this.message).getRepoName()});
        CrawledDataWrappedResponse crawledDataWrappedResponse = this.getResponseFetcher().fetchEntity(Commit.class, ((GithubSimpleTagJobMessage)this.message).url());
        this.handleResponse((Commit)((Object)crawledDataWrappedResponse.getEntity()));
        return crawledDataWrappedResponse;
    }

    private void handleResponse(Commit c) throws CrawlerWorkException {
        if (!this.isValidCommit(c)) {
            return;
        }
        logger.debug("Saving simple tag - {} in project - {}, repo - {}", new Object[]{((GithubSimpleTagJobMessage)this.message).getId(), ((GithubSimpleTagJobMessage)this.message).getOrgName(), ((GithubSimpleTagJobMessage)this.message).getRepoName()});
        UMWrappedEntity umWrappedEntity = this.converter.convert((Object)c);
        this.repository.save(umWrappedEntity);
    }
}

