/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.github.components;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xebialabs.agatha.crawlers.AbstractHttpCrawler;
import com.xebialabs.agatha.crawlers.ResponseEntity;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.github.GithubCrawler;
import com.xebialabs.agatha.crawlers.github.components.GithubResponseEnricher;
import com.xebialabs.agatha.crawlers.github.models.dtos.CollectionResponse;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.components.ResponseFetcher;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GithubResponseFetcher
extends ResponseFetcher<GithubCrawler> {
    private static final Logger logger = LoggerFactory.getLogger(GithubResponseFetcher.class);
    private final GithubResponseEnricher responseEnricher = new GithubResponseEnricher();

    public GithubResponseFetcher(GithubCrawler crawler) {
        super((AbstractHttpCrawler)crawler);
    }

    protected Request buildRequest(URL url) {
        return new Request.Builder().url(url).addHeader("Accept", "application/vnd.github.v3+json").build();
    }

    public <R> CrawledDataWrappedResponse<CollectionResponse> fetchEntities(TypeReference<List<R>> listTypeReference, URL url) throws CrawlerWorkException {
        String content = null;
        try {
            ResponseEntity responseEntity = this.responseAsEntity(url);
            content = responseEntity.asString();
            List results = (List)((GithubCrawler)this.crawler).getMapper().readValue(content, listTypeReference);
            CollectionResponse collectionResponse = new CollectionResponse(results);
            this.responseEnricher.enrichResponseWithPagination(collectionResponse, responseEntity.getHeaders());
            return new CrawledDataWrappedResponse(collectionResponse);
        }
        catch (IOException e) {
            logger.error("Error occurred in fetchEntities for Url - {}, with Response - {}", (Object)url, (Object)content);
            throw new CrawlerWorkException((Throwable)e);
        }
    }
}

