/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.github.services;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.github.GithubCrawler;
import com.xebialabs.agatha.crawlers.github.components.GithubResponseFetcher;
import com.xebialabs.agatha.crawlers.github.messages.GithubCommitJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubRepoJobMessage;
import com.xebialabs.agatha.crawlers.github.models.Commit;
import com.xebialabs.agatha.crawlers.github.models.Sha;
import com.xebialabs.agatha.crawlers.github.repository.CommitRepository;
import com.xebialabs.agatha.crawlers.github.services.GithubBaseCrawl;
import com.xebialabs.agatha.crawlers.github.transform.converters.CommitConverter;
import com.xebialabs.agatha.crawlers.github.transform.models.CommitUM;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.repository.KeyValueRepository;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GithubCommitCrawl
extends GithubBaseCrawl<GithubCommitJobMessage, Commit> {
    private static final Logger logger = LoggerFactory.getLogger(GithubCommitCrawl.class);
    private final UMConverter<CommitUM, Commit> converter;
    private final KeyValueRepository<CommitUM> repository;

    public GithubCommitCrawl(GithubCrawler crawler, GithubCommitJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage, new GithubResponseFetcher(crawler));
        this.converter = new CommitConverter("GithubPlugin", "v1", "COMMIT", "v1").setOrganization(message.getOrgName()).setRepo(message.getRepoName());
        this.repository = new CommitRepository(crawler, dataMessage);
    }

    @Override
    protected CrawledDataWrappedResponse<Commit> processGithubMessage() throws CrawlerWorkException {
        logger.debug("Process GithubCommitJobMessage for endpoint {} - commit - {}, org {}, repo - {}", new Object[]{((GithubCommitJobMessage)this.message).getBaseUrl(), ((GithubCommitJobMessage)this.message).getId(), ((GithubCommitJobMessage)this.message).getOrgName(), ((GithubCommitJobMessage)this.message).getRepoName()});
        CrawledDataWrappedResponse crawledDataWrappedResponse = this.getResponseFetcher().fetchEntity(Commit.class, ((GithubCommitJobMessage)this.message).url());
        this.handleResponse((Commit)((Object)crawledDataWrappedResponse.getEntity()));
        return crawledDataWrappedResponse;
    }

    private void handleResponse(Commit c) throws CrawlerWorkException {
        if (!this.isValidCommit(c)) {
            return;
        }
        logger.debug("Saving commit - {} in project - {}, repo - {}", new Object[]{c.getSha(), ((GithubCommitJobMessage)this.message).getOrgName(), ((GithubCommitJobMessage)this.message).getRepoName()});
        UMWrappedEntity umWrappedEntity = this.converter.convert((Object)c);
        boolean crawlParents = this.repository.save(umWrappedEntity);
        if (crawlParents) {
            logger.debug("Pushing {} parent commit depth jobs from commit {}", (Object)c.getParents().size(), (Object)c.getSha());
            this.sendCommitDepthJobMessages((GithubRepoJobMessage)this.message, c.getParents().stream().map(Sha::getSha).collect(Collectors.toSet()));
        }
    }
}

