/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.github.services;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.github.GithubCrawler;
import com.xebialabs.agatha.crawlers.github.GithubUtil;
import com.xebialabs.agatha.crawlers.github.components.GithubResponseFetcher;
import com.xebialabs.agatha.crawlers.github.messages.GithubSimpleTagJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubTagJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubTagsJobMessage;
import com.xebialabs.agatha.crawlers.github.models.Sha;
import com.xebialabs.agatha.crawlers.github.models.Tag;
import com.xebialabs.agatha.crawlers.github.models.dtos.CollectionResponse;
import com.xebialabs.agatha.crawlers.github.services.GithubBaseCrawl;
import com.xebialabs.agatha.crawlers.github.transform.converters.SimpleTagConverter;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import com.xebialabs.impact.api.KnownArtefactRequestDescriptionVM;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GithubTagsCrawl
extends GithubBaseCrawl<GithubTagsJobMessage, CollectionResponse> {
    private static final Logger logger = LoggerFactory.getLogger(GithubTagsCrawl.class);
    private final SimpleTagConverter simpleTagConverter;

    public GithubTagsCrawl(GithubCrawler crawler, GithubTagsJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage, new GithubResponseFetcher(crawler));
        this.simpleTagConverter = new SimpleTagConverter("GithubPlugin", "v1", "LABEL", "v1").setRepo(message.getRepoName()).setOrganization(message.getOrgName());
    }

    @Override
    protected CrawledDataWrappedResponse<CollectionResponse> processGithubMessage() throws CrawlerWorkException {
        logger.debug("Process GithubTagsJobMessage for endpoint {} - org {}, repo - {} ", new Object[]{((GithubTagsJobMessage)this.message).getBaseUrl(), ((GithubTagsJobMessage)this.message).getOrgName(), ((GithubTagsJobMessage)this.message).getRepoName()});
        CrawledDataWrappedResponse<CollectionResponse> crawledDataWrappedResponse = this.getResponseFetcher().fetchEntities(new TypeReference<List<Tag>>(){}, ((GithubTagsJobMessage)this.message).url());
        this.handleResponse((CollectionResponse)((Object)crawledDataWrappedResponse.getEntity()));
        return crawledDataWrappedResponse;
    }

    private void handleResponse(CollectionResponse<Tag> response) throws CrawlerWorkException {
        logger.debug("Found {} tags in org - {}, repo - {}", new Object[]{response.getResults().size(), ((GithubTagsJobMessage)this.message).getOrgName(), ((GithubTagsJobMessage)this.message).getRepoName()});
        List<Tag> tags = response.getResults();
        List simpleTags = tags.stream().filter(tag -> "commit".equals(tag.getObject().getType())).filter(tag -> tag.getRef().startsWith("refs/tags/")).collect(Collectors.toList());
        Map knownArtefacts = this.dataMessage.getMetadata().isIncremental() ? ((GithubCrawler)this.crawler).getKnownArtefacts(simpleTags.stream().map(tag -> new KnownArtefactRequestDescriptionVM().setArtefactId(this.simpleTagConverter.generateId(this.simpleTagConverter.getSimpleTagId((Tag)((Object)tag)))).setVersion(tag.getObject().getSha())).collect(Collectors.toList()), ((GithubTagsJobMessage)this.message).getDataSourceDetails().getDataSourceId(), DataSourceTypeEnum.LABEL) : new HashMap();
        for (Tag tag2 : simpleTags.stream().filter(tag -> {
            String id = this.simpleTagConverter.generateId(this.simpleTagConverter.getSimpleTagId((Tag)((Object)tag)));
            return knownArtefacts.get(id) == null || (Boolean)knownArtefacts.get(id) == false;
        })::iterator) {
            this.sendSimpleTagMessage(tag2);
        }
        for (String sha : tags.stream().map(Tag::getObject).filter(object -> "tag".equals(object.getType())).map(Sha::getSha)::iterator) {
            this.sendMessage(sha);
        }
    }

    private void sendSimpleTagMessage(Tag tag) throws CrawlerWorkException {
        try {
            GithubSimpleTagJobMessage json = ((GithubCrawler)this.crawler).generateNewMessage(GithubSimpleTagJobMessage.class, this.message).setId(this.simpleTagConverter.getSimpleTagId(tag)).setCommitSha(tag.getObject().getSha());
            ((GithubCrawler)this.crawler).sendCrawlerTaskMessage(this.createDataMessage(GithubSimpleTagJobMessage.class.getSimpleName(), json));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    private void sendMessage(String tagSha) throws CrawlerWorkException {
        try {
            GithubTagJobMessage msg = ((GithubCrawler)this.crawler).generateNewMessage(GithubTagJobMessage.class, this.message).setId(tagSha);
            ((GithubCrawler)this.crawler).sendCrawlerTaskMessage(this.createDataMessage(GithubTagJobMessage.class.getSimpleName(), msg));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    private List<String> filteredTags(List<String> tags) {
        if (((GithubTagsJobMessage)this.message).getMetadata().isIncremental()) {
            tags = this.filterOnlyUnknownTags(tags);
            return tags;
        }
        return tags;
    }

    private List<String> filterOnlyUnknownTags(List<String> tags) {
        logger.debug("[Incremental Mode] Asking dedupe data for the following tags for filtering: {}", tags);
        Set knownTags = ((GithubCrawler)this.crawler).getKnownArtefacts(tags.stream().map(t -> new KnownArtefactRequestDescriptionVM().setArtefactId(GithubUtil.generateDataId(((GithubTagsJobMessage)this.message).getOrgName(), ((GithubTagsJobMessage)this.message).getRepoName(), t)).setVersion("0")).collect(Collectors.toList()), ((GithubTagsJobMessage)this.message).getDataSourceDetails().getDataSourceId(), DataSourceTypeEnum.LABEL).entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
        logger.info("[Incremental Mode] Found {} known artefacts out of {} tags", (Object)knownTags.size(), (Object)tags.size());
        return tags.stream().filter(t -> !knownTags.contains(GithubUtil.generateDataId(((GithubTagsJobMessage)this.message).getOrgName(), ((GithubTagsJobMessage)this.message).getRepoName(), t))).collect(Collectors.toList());
    }
}

