/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.github.services;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.github.GithubCrawler;
import com.xebialabs.agatha.crawlers.github.components.GithubResponseFetcher;
import com.xebialabs.agatha.crawlers.github.messages.GithubJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubPullRequestJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubPullRequestsJobMessage;
import com.xebialabs.agatha.crawlers.github.models.PullRequest;
import com.xebialabs.agatha.crawlers.github.models.dtos.CollectionResponse;
import com.xebialabs.agatha.crawlers.github.services.GithubBaseCrawl;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.services.Paginated;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GithubPullRequestsCrawl
extends GithubBaseCrawl<GithubPullRequestsJobMessage, CollectionResponse>
implements Paginated {
    private static final Logger logger = LoggerFactory.getLogger(GithubPullRequestsCrawl.class);

    public GithubPullRequestsCrawl(GithubCrawler crawler, GithubPullRequestsJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage, new GithubResponseFetcher(crawler));
    }

    protected BaseCrawlerMessage newMessage() throws CrawlerWorkException {
        try {
            GithubJobMessage json = ((GithubCrawler)this.crawler).generateNewMessage(GithubPullRequestsJobMessage.class, this.message).setLimit(((GithubPullRequestsJobMessage)this.message).getLimit()).setPage(((GithubPullRequestsJobMessage)this.message).nextPage());
            return this.createDataMessage(GithubPullRequestsJobMessage.class.getSimpleName(), json);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    @Override
    protected CrawledDataWrappedResponse<CollectionResponse> processGithubMessage() throws CrawlerWorkException {
        logger.debug("Process GithubPullRequestsJobMessage for endpoint {} - org {}, repo - {} ", new Object[]{((GithubPullRequestsJobMessage)this.message).getBaseUrl(), ((GithubPullRequestsJobMessage)this.message).getOrgName(), ((GithubPullRequestsJobMessage)this.message).getRepoName()});
        CrawledDataWrappedResponse<CollectionResponse> crawledDataWrappedResponse = this.getResponseFetcher().fetchEntities(new TypeReference<List<PullRequest>>(){}, ((GithubPullRequestsJobMessage)this.message).url());
        this.handleResponse((CollectionResponse)((Object)crawledDataWrappedResponse.getEntity()));
        return crawledDataWrappedResponse;
    }

    private void handleResponse(CollectionResponse<PullRequest> response) throws CrawlerWorkException {
        logger.debug("Found {} Pull Requests in org - {}, repo - {}", new Object[]{response.getResults().size(), ((GithubPullRequestsJobMessage)this.message).getOrgName(), ((GithubPullRequestsJobMessage)this.message).getRepoName()});
        List<PullRequest> pullRequests = response.getResults();
        for (PullRequest pullRequest : pullRequests) {
            this.sendMessage(pullRequest);
        }
    }

    private void sendMessage(PullRequest pullRequest) throws CrawlerWorkException {
        try {
            GithubPullRequestsJobMessage message = (GithubPullRequestsJobMessage)this.message;
            GithubPullRequestJobMessage json = ((GithubCrawler)this.crawler).generateNewMessage(GithubPullRequestJobMessage.class, message);
            json.setNumber(pullRequest.getNumber());
            ((GithubCrawler)this.crawler).sendCrawlerTaskMessage(this.createDataMessage(GithubPullRequestJobMessage.class.getSimpleName(), json));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }
}

