/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.ssl.KeyStoreBuilder;
import com.typesafe.sslconfig.ssl.KeystoreFormats$;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u0017\t\u0019c)\u001b7f\u001f:\u001cE.Y:ta\u0006$\bNQ1tK\u0012\\U-_*u_J,')^5mI\u0016\u0014(BA\u0002\u0005\u0003\r\u00198\u000f\u001c\u0006\u0003\u000b\u0019\t\u0011b]:mG>tg-[4\u000b\u0005\u001dA\u0011\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003%\t1aY8n\u0007\u0001\u00192\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\u0010\u0017\u0016L8\u000b^8sK\n+\u0018\u000e\u001c3fe\"Aq\u0003\u0001B\u0001B\u0003%\u0001$\u0001\u0007lKf\u001cFo\u001c:f)f\u0004X\r\u0005\u0002\u001aA9\u0011!D\b\t\u000379i\u0011\u0001\b\u0006\u0003;)\ta\u0001\u0010:p_Rt\u0014BA\u0010\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011E\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}q\u0001\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\u0011\u0019LG.\u001a)bi\"D\u0001B\n\u0001\u0003\u0002\u0003\u0006IaJ\u0001\ta\u0006\u001c8o^8sIB\u0019Q\u0002\u000b\u0016\n\u0005%r!AB(qi&|g\u000eE\u0002\u000eW5J!\u0001\f\b\u0003\u000b\u0005\u0013(/Y=\u0011\u00055q\u0013BA\u0018\u000f\u0005\u0011\u0019\u0005.\u0019:\t\u000bE\u0002A\u0011\u0001\u001a\u0002\rqJg.\u001b;?)\u0011\u0019D'\u000e\u001c\u0011\u0005M\u0001\u0001\"B\f1\u0001\u0004A\u0002\"\u0002\u00131\u0001\u0004A\u0002\"\u0002\u00141\u0001\u00049\u0003\"\u0002\u001d\u0001\t\u0003I\u0014!\u00022vS2$G#\u0001\u001e\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0003}\nAA[1wC&\u0011\u0011\t\u0010\u0002\t\u0017\u0016L8\u000b^8sK\")1\t\u0001C\u0001\t\u0006)\"-^5mI\u001a\u0013x.\\&fsN$xN]3GS2,Gc\u0001\u001eF\u000f\")aI\u0011a\u00011\u0005I1\u000f^8sKRK\b/\u001a\u0005\u0006\u0011\n\u0003\r!S\u0001\u0003SN\u0004\"AS'\u000e\u0003-S!\u0001\u0014 \u0002\u0005%|\u0017B\u0001(L\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000bA\u0003A\u0011A)\u0002!I,\u0017\rZ\"feRLg-[2bi\u0016\u001cHC\u0001*b!\r\u0019\u0006l\u0017\b\u0003)Zs!aG+\n\u0003=I!a\u0016\b\u0002\u000fA\f7m[1hK&\u0011\u0011L\u0017\u0002\t\u0013R,'/\u00192mK*\u0011qK\u0004\t\u00039~k\u0011!\u0018\u0006\u0003=r\nAaY3si&\u0011\u0001-\u0018\u0002\f\u0007\u0016\u0014H/\u001b4jG\u0006$X\rC\u0003I\u001f\u0002\u0007\u0011\n")
public class FileOnClasspathBasedKeyStoreBuilder
implements KeyStoreBuilder {
    private final String keyStoreType;
    private final String filePath;
    private final Option<char[]> password;

    @Override
    public KeyStore build() {
        KeyStore keyStore;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.filePath);
        Predef$.MODULE$.require(is != null, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(48).append("Key store file ").append($this.filePath).append(" was not found on the class path!").toString());
        String string = this.keyStoreType;
        if ("PEM".equals(string)) {
            Iterable<Certificate> certs = this.readCertificates(is);
            keyStore = KeystoreFormats$.MODULE$.loadCertificates((TraversableOnce<Certificate>)certs);
        } else {
            keyStore = this.buildFromKeystoreFile(string, is);
        }
        return keyStore;
    }

    public KeyStore buildFromKeystoreFile(String storeType, InputStream is) {
        KeyStore keyStore;
        try (BufferedInputStream inputStream = new BufferedInputStream(is);){
            String storeType2 = this.keyStoreType;
            KeyStore store = KeyStore.getInstance(storeType2);
            store.load(inputStream, (char[])this.password.orNull(Predef$.MODULE$.$conforms()));
            keyStore = store;
        }
        return keyStore;
    }

    public Iterable<Certificate> readCertificates(InputStream is) {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        BufferedInputStream bis = new BufferedInputStream(is);
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(cf.generateCertificates(bis)).asScala();
    }

    public FileOnClasspathBasedKeyStoreBuilder(String keyStoreType, String filePath, Option<char[]> password) {
        this.keyStoreType = keyStoreType;
        this.filePath = filePath;
        this.password = password;
    }
}

