/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.github.services;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.github.GithubCrawler;
import com.xebialabs.agatha.crawlers.github.components.GithubResponseFetcher;
import com.xebialabs.agatha.crawlers.github.messages.GithubBranchJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubRepoJobMessage;
import com.xebialabs.agatha.crawlers.github.models.Branch;
import com.xebialabs.agatha.crawlers.github.models.dtos.CollectionResponse;
import com.xebialabs.agatha.crawlers.github.services.GithubBaseCrawl;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.services.Paginated;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GithubBranchCrawl
extends GithubBaseCrawl<GithubBranchJobMessage, CollectionResponse>
implements Paginated {
    private static final Logger logger = LoggerFactory.getLogger(GithubBranchCrawl.class);

    public GithubBranchCrawl(GithubCrawler crawler, GithubBranchJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage, new GithubResponseFetcher(crawler));
    }

    protected BaseCrawlerMessage newMessage() throws CrawlerWorkException {
        try {
            GithubJobMessage msg = ((GithubCrawler)this.crawler).generateNewMessage(GithubBranchJobMessage.class, this.message).setLimit(((GithubBranchJobMessage)this.message).getLimit()).setPage(((GithubBranchJobMessage)this.message).nextPage());
            return this.createDataMessage(GithubBranchJobMessage.class.getSimpleName(), msg);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    @Override
    protected CrawledDataWrappedResponse<CollectionResponse> processGithubMessage() throws CrawlerWorkException {
        logger.debug("Process GithubBranchJobMessage for endpoint {} - org {}, repo - {} ", new Object[]{((GithubBranchJobMessage)this.message).getBaseUrl(), ((GithubBranchJobMessage)this.message).getOrgName(), ((GithubBranchJobMessage)this.message).getRepoName()});
        CrawledDataWrappedResponse<CollectionResponse> crawledDataWrappedResponse = this.getResponseFetcher().fetchEntities(new TypeReference<List<Branch>>(){}, ((GithubBranchJobMessage)this.message).url());
        this.handleResponse((CollectionResponse)((Object)crawledDataWrappedResponse.getEntity()));
        return crawledDataWrappedResponse;
    }

    private void handleResponse(CollectionResponse<Branch> response) throws CrawlerWorkException {
        logger.debug("Found {} branches in org - {}, repo - {}", new Object[]{response.getResults().size(), ((GithubBranchJobMessage)this.message).getOrgName(), ((GithubBranchJobMessage)this.message).getRepoName()});
        List<Branch> branches = response.getResults();
        this.sendCommitDepthJobMessages((GithubRepoJobMessage)this.message, branches.stream().map(Branch::getCommitSha).collect(Collectors.toSet()));
    }
}

