/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.github.messages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.github.GithubUrlHelper;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.net.URL;

public class GithubJobMessage
extends BaseCrawlerMessage<GithubJobMessage> {
    private String baseUrl;
    private int page = 1;
    private int limit = 50;
    private String orgName;

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public GithubJobMessage setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public int getPage() {
        return this.page;
    }

    public GithubJobMessage setPage(int page) {
        this.page = page;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public GithubJobMessage setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public GithubJobMessage setOrgName(String orgName) {
        this.orgName = orgName;
        return this;
    }

    public URL url() throws CrawlerWorkException {
        return GithubUrlHelper.reposURL(this.baseUrl, this.limit, this.page);
    }

    @JsonIgnore
    public int nextPage() {
        return ++this.page;
    }

    protected String makeGithubMessageKey(String priority) {
        try {
            return String.format("%s-%s", priority, this.url().toString().substring(this.baseUrl.length()));
        }
        catch (CrawlerWorkException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getMessageKey() {
        return this.makeGithubMessageKey("0-job-");
    }
}

